
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Optional Service Descriptions.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDescriptionType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Description" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Description -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceDescriptionType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private List<Description> descriptionList = new ArrayList<Description>();

    /** 
     * Get the list of 'Description' element items.
     * 
     * @return list
     */
    public List<Description> getDescriptionList() {
        return descriptionList;
    }

    /** 
     * Set the list of 'Description' element items.
     * 
     * @param list
     */
    public void setDescriptionList(List<Description> list) {
        descriptionList = list;
    }
    /** 
     * Service Description detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Description" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DescriptionType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Description extends DescriptionType implements
        Serializable
    {
        private String application;

        /** 
         * Get the 'Application' element value. Description Application.  Examples: SEAT 3B, Discount 15P
         * 
         * @return value
         */
        public String getApplication() {
            return application;
        }

        /** 
         * Set the 'Application' element value. Description Application.  Examples: SEAT 3B, Discount 15P
         * 
         * @param application
         */
        public void setApplication(String application) {
            this.application = application;
        }
    }
}
