
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * OPTIONAL SERVICE ENCODING definition.

 Note: Includes IATA Optional Service Reason for Issuance Code (RFIC) code and Issuance Sub Code.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceEncodingType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:RFIC" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="SubCode" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceEncodingType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private RFIC RFIC;
    private String code;
    private String subCode;

    /** 
     * Get the 'RFIC' element value.
     * 
     * @return value
     */
    public RFIC getRFIC() {
        return RFIC;
    }

    /** 
     * Set the 'RFIC' element value.
     * 
     * @param RFIC
     */
    public void setRFIC(RFIC RFIC) {
        this.RFIC = RFIC;
    }

    /** 
     * Get the 'Code' element value. Service code. Examples:
    XLEG (Extra Leg Room Seat, implementer encoding)
    XBAG (Extra Bag, implementer encoding).  
    Used in conjunction with SubCode (Associated Reason For Issuance SubCode).
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Service code. Examples:
    XLEG (Extra Leg Room Seat, implementer encoding)
    XBAG (Extra Bag, implementer encoding).  
    Used in conjunction with SubCode (Associated Reason For Issuance SubCode).
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'SubCode' element value. Associated Reason For Issuance Sub Code.
    
    Examples:
    0CC (First Checked Bag)
    0B1 (In-flight Entertainment)
    0BX (Lounge)
    0B3 (Meal/ Beverage)
    0B5 (Pre-reserved Seat Assignment)
    0G6 (Priority Boarding)

    Are these on an IATA Codelist or do they need to be added via FastTrack?
     * 
     * @return value
     */
    public String getSubCode() {
        return subCode;
    }

    /** 
     * Set the 'SubCode' element value. Associated Reason For Issuance Sub Code.
    
    Examples:
    0CC (First Checked Bag)
    0B1 (In-flight Entertainment)
    0BX (Lounge)
    0B3 (Meal/ Beverage)
    0B5 (Pre-reserved Seat Assignment)
    0G6 (Priority Boarding)

    Are these on an IATA Codelist or do they need to be added via FastTrack?
     * 
     * @param subCode
     */
    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }
}
