
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OPTIONAL SERVICE FILTER definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceFilterType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="GroupCode"/>
 *         &lt;xs:element type="xs:string" name="SubGroupCode" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceFilterType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private String groupCode;
    private List<String> subGroupCodeList = new ArrayList<String>();

    /** 
     * Get the 'GroupCode' element value. Identifies additional services codes, and may refer to ATPCO additional services information or airline specific/ bilaterally agreed codes.
     * 
     * @return value
     */
    public String getGroupCode() {
        return groupCode;
    }

    /** 
     * Set the 'GroupCode' element value. Identifies additional services codes, and may refer to ATPCO additional services information or airline specific/ bilaterally agreed codes.
     * 
     * @param groupCode
     */
    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    /** 
     * Get the list of 'SubGroupCode' element items. Service Sub-Group Code(s).

    Group BG: CT (Container), PP (Pre-Paid Excess Baggage)
    Group IE: IT (Internet Access), TV (Television)


     * 
     * @return list
     */
    public List<String> getSubGroupCodeList() {
        return subGroupCodeList;
    }

    /** 
     * Set the list of 'SubGroupCode' element items. Service Sub-Group Code(s).

    Group BG: CT (Container), PP (Pre-Paid Excess Baggage)
    Group IE: IT (Internet Access), TV (Television)


     * 
     * @param list
     */
    public void setSubGroupCodeList(List<String> list) {
        subGroupCodeList = list;
    }
}
