
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * UNIQUE SERVICE ID representation.

 The airline-assigned unique Service ID.  Example: SRVC_ccecc4aa-791867b9b2e6
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceID_Type">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attributeGroup ref="ns:ObjectKeyAttrGroup"/>
 *       &lt;xs:attribute type="xs:string" use="required" name="Owner"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceIDType implements Serializable
{
    private String string;
    private ObjectKeyAttrGroup objectKeyAttrGroup;
    private String owner;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectKeyAttrGroup getObjectKeyAttrGroup() {
        return objectKeyAttrGroup;
    }

    /** 
     * Set the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @param objectKeyAttrGroup
     */
    public void setObjectKeyAttrGroup(ObjectKeyAttrGroup objectKeyAttrGroup) {
        this.objectKeyAttrGroup = objectKeyAttrGroup;
    }

    /** 
     * Get the 'Owner' attribute value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' attribute value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }
}
