
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * SHOPPING RESPONSE object definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShoppingResponseID_Type">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Owner" minOccurs="0"/>
 *         &lt;xs:element name="ResponseID">
 *           &lt;xs:complexType>
 *             &lt;xs:simpleContent>
 *               &lt;xs:extension base="xs:string">
 *                 &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:simpleContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="AssociatedIDs" minOccurs="0">
 *           &lt;!-- Reference to inner class AssociatedIDs -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ShoppingResponseIDType extends AssociatedObjectBaseType implements
    Serializable
{
    private String owner;
    private String responseIDString;
    private String responseIDRefs;
    private AssociatedIDs associatedIDs;

    /** 
     * Get the 'Owner' element value. Designator of Airline that owns/ assigned these IDs. Examples: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' element value. Designator of Airline that owns/ assigned these IDs. Examples: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getResponseIDString() {
        return responseIDString;
    }

    /** 
     * Set the extension value.
     * 
     * @param responseIDString
     */
    public void setResponseIDString(String responseIDString) {
        this.responseIDString = responseIDString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getResponseIDRefs() {
        return responseIDRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param responseIDRefs
     */
    public void setResponseIDRefs(String responseIDRefs) {
        this.responseIDRefs = responseIDRefs;
    }

    /** 
     * Get the 'AssociatedIDs' element value.
     * 
     * @return value
     */
    public AssociatedIDs getAssociatedIDs() {
        return associatedIDs;
    }

    /** 
     * Set the 'AssociatedIDs' element value.
     * 
     * @param associatedIDs
     */
    public void setAssociatedIDs(AssociatedIDs associatedIDs) {
        this.associatedIDs = associatedIDs;
    }
    /** 
     * Associated Offer Item ID and Service ID collection.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedIDs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AssociatedID" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AssociatedID -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AssociatedIDs implements Serializable
    {
        private List<AssociatedID> associatedIDList = new ArrayList<AssociatedID>();

        /** 
         * Get the list of 'AssociatedID' element items.
         * 
         * @return list
         */
        public List<AssociatedID> getAssociatedIDList() {
            return associatedIDList;
        }

        /** 
         * Set the list of 'AssociatedID' element items.
         * 
         * @param list
         */
        public void setAssociatedIDList(List<AssociatedID> list) {
            associatedIDList = list;
        }
        /** 
         * Offer/ Service Collection detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedID" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:OfferItemID" minOccurs="0"/>
         *       &lt;xs:element ref="ns:ServiceID" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AssociatedID implements Serializable
        {
            private OfferItemID offerItemID;
            private ServiceIDType serviceID;

            /** 
             * Get the 'OfferItemID' element value.
             * 
             * @return value
             */
            public OfferItemID getOfferItemID() {
                return offerItemID;
            }

            /** 
             * Set the 'OfferItemID' element value.
             * 
             * @param offerItemID
             */
            public void setOfferItemID(OfferItemID offerItemID) {
                this.offerItemID = offerItemID;
            }

            /** 
             * Get the 'ServiceID' element value.
             * 
             * @return value
             */
            public ServiceIDType getServiceID() {
                return serviceID;
            }

            /** 
             * Set the 'ServiceID' element value.
             * 
             * @param serviceID
             */
            public void setServiceID(ServiceIDType serviceID) {
                this.serviceID = serviceID;
            }
        }
    }
}
