
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * ORDER INPUT SHOPPING RESPONSE object definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShoppingResponseOrderType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Owner"/>
 *         &lt;xs:element name="ResponseID">
 *           &lt;xs:complexType>
 *             &lt;xs:simpleContent>
 *               &lt;xs:extension base="xs:string">
 *                 &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:simpleContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Offers">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element name="Offer" maxOccurs="unbounded">
 *                 &lt;!-- Reference to inner class Offer -->
 *               &lt;/xs:element>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ShoppingResponseOrderType extends AssociatedObjectBaseType
    implements Serializable
{
    private String owner;
    private String responseIDString;
    private String responseIDRefs;
    private List<Offer> offerList = new ArrayList<Offer>();

    /** 
     * Get the 'Owner' element value. 
                  Designator of Airline that owns/ assigned these IDs. Examples: BA Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' element value. 
                  Designator of Airline that owns/ assigned these IDs. Examples: BA Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getResponseIDString() {
        return responseIDString;
    }

    /** 
     * Set the extension value.
     * 
     * @param responseIDString
     */
    public void setResponseIDString(String responseIDString) {
        this.responseIDString = responseIDString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getResponseIDRefs() {
        return responseIDRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param responseIDRefs
     */
    public void setResponseIDRefs(String responseIDRefs) {
        this.responseIDRefs = responseIDRefs;
    }

    /** 
     * Get the list of 'Offer' element items. Associated response Offers list.
     * 
     * @return list
     */
    public List<Offer> getOfferList() {
        return offerList;
    }

    /** 
     * Set the list of 'Offer' element items. Associated response Offers list.
     * 
     * @param list
     */
    public void setOfferList(List<Offer> list) {
        offerList = list;
    }
    /** 
     * Associated Offer
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Offer" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:ItemID_Type" name="OfferID"/>
     *       &lt;xs:element name="OfferItems">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="OfferItem" maxOccurs="unbounded">
     *               &lt;!-- Reference to inner class OfferItem -->
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="TotalPrice" minOccurs="0">
     *         &lt;!-- Reference to inner class TotalPrice -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Offer implements Serializable
    {
        private ItemIDType offerID;
        private List<OfferItem> offerItemList = new ArrayList<OfferItem>();
        private TotalPrice totalPrice;

        /** 
         * Get the 'OfferID' element value. Globally unique Offer instance ID. length should not be exceed 64 character and it is recommended to not use dash char in it.Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
         * 
         * @return value
         */
        public ItemIDType getOfferID() {
            return offerID;
        }

        /** 
         * Set the 'OfferID' element value. Globally unique Offer instance ID. length should not be exceed 64 character and it is recommended to not use dash char in it.Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
         * 
         * @param offerID
         */
        public void setOfferID(ItemIDType offerID) {
            this.offerID = offerID;
        }

        /** 
         * Get the list of 'OfferItem' element items. Associated Order Item(s).
         * 
         * @return list
         */
        public List<OfferItem> getOfferItemList() {
            return offerItemList;
        }

        /** 
         * Set the list of 'OfferItem' element items. Associated Order Item(s).
         * 
         * @param list
         */
        public void setOfferItemList(List<OfferItem> list) {
            offerItemList = list;
        }

        /** 
         * Get the 'TotalPrice' element value.
         * 
         * @return value
         */
        public TotalPrice getTotalPrice() {
            return totalPrice;
        }

        /** 
         * Set the 'TotalPrice' element value.
         * 
         * @param totalPrice
         */
        public void setTotalPrice(TotalPrice totalPrice) {
            this.totalPrice = totalPrice;
        }
        /** 
         * 
                          Offer Item ID with passenger association and offer detail including wait list and inventory guarantee.
                        
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItem" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="ns:OfferItemID"/>
         *           &lt;xs:element name="Passengers" minOccurs="0">
         *             &lt;xs:complexType>
         *               &lt;xs:sequence>
         *                 &lt;xs:element ref="ns:PassengerReference"/>
         *               &lt;/xs:sequence>
         *             &lt;/xs:complexType>
         *           &lt;/xs:element>
         *           &lt;xs:element name="TotalPrice" minOccurs="0">
         *             &lt;!-- Reference to inner class TotalPrice -->
         *           &lt;/xs:element>
         *           &lt;xs:element ref="ns:ApplicableFlight" minOccurs="0"/>
         *           &lt;xs:element ref="ns:IncludedService" minOccurs="0"/>
         *           &lt;xs:element name="AssociatedServices" minOccurs="0">
         *             &lt;!-- Reference to inner class AssociatedServices -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="Details" minOccurs="0">
         *             &lt;!-- Reference to inner class Details -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OfferItem extends AssociatedObjectBaseType
            implements Serializable
        {
            private OfferItemID offerItemID;
            private PassengerReference passengers;
            private TotalPrice totalPrice;
            private FlightInfoAssocType applicableFlight;
            private IncludedService includedService;
            private AssociatedServices associatedServices;
            private Details details;

            /** 
             * Get the 'OfferItemID' element value.
             * 
             * @return value
             */
            public OfferItemID getOfferItemID() {
                return offerItemID;
            }

            /** 
             * Set the 'OfferItemID' element value.
             * 
             * @param offerItemID
             */
            public void setOfferItemID(OfferItemID offerItemID) {
                this.offerItemID = offerItemID;
            }

            /** 
             * Get the 'PassengerReference' element value. 
                                            Association to multiple Passenger instance(s). Example: pax1 pax2
                                          
             * 
             * @return value
             */
            public PassengerReference getPassengers() {
                return passengers;
            }

            /** 
             * Set the 'PassengerReference' element value. 
                                            Association to multiple Passenger instance(s). Example: pax1 pax2
                                          
             * 
             * @param passengers
             */
            public void setPassengers(PassengerReference passengers) {
                this.passengers = passengers;
            }

            /** 
             * Get the 'TotalPrice' element value.
             * 
             * @return value
             */
            public TotalPrice getTotalPrice() {
                return totalPrice;
            }

            /** 
             * Set the 'TotalPrice' element value.
             * 
             * @param totalPrice
             */
            public void setTotalPrice(TotalPrice totalPrice) {
                this.totalPrice = totalPrice;
            }

            /** 
             * Get the 'ApplicableFlight' element value.
             * 
             * @return value
             */
            public FlightInfoAssocType getApplicableFlight() {
                return applicableFlight;
            }

            /** 
             * Set the 'ApplicableFlight' element value.
             * 
             * @param applicableFlight
             */
            public void setApplicableFlight(FlightInfoAssocType applicableFlight) {
                this.applicableFlight = applicableFlight;
            }

            /** 
             * Get the 'IncludedService' element value.
             * 
             * @return value
             */
            public IncludedService getIncludedService() {
                return includedService;
            }

            /** 
             * Set the 'IncludedService' element value.
             * 
             * @param includedService
             */
            public void setIncludedService(IncludedService includedService) {
                this.includedService = includedService;
            }

            /** 
             * Get the 'AssociatedServices' element value.
             * 
             * @return value
             */
            public AssociatedServices getAssociatedServices() {
                return associatedServices;
            }

            /** 
             * Set the 'AssociatedServices' element value.
             * 
             * @param associatedServices
             */
            public void setAssociatedServices(
                    AssociatedServices associatedServices) {
                this.associatedServices = associatedServices;
            }

            /** 
             * Get the 'Details' element value.
             * 
             * @return value
             */
            public Details getDetails() {
                return details;
            }

            /** 
             * Set the 'Details' element value.
             * 
             * @param details
             */
            public void setDetails(Details details) {
                this.details = details;
            }
            /** 
             * The total price for all Travelers associated with this offer.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalPrice" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element ref="ns:AwardPricing"/>
             *       &lt;xs:element ref="ns:CombinationPricing"/>
             *       &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
             *       &lt;xs:element ref="ns:DetailCurrencyPrice"/>
             *       &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
             *     &lt;/xs:choice>
             *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class TotalPrice implements Serializable
            {
                private int choiceSelect = -1;
                private static final int AWARD_PRICING_CHOICE = 0;
                private static final int COMBINATION_PRICING_CHOICE = 1;
                private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 2;
                private static final int DETAIL_CURRENCY_PRICE_CHOICE = 3;
                private static final int ENCODED_CURRENCY_PRICE_CHOICE = 4;
                private AwardPriceUnitType awardPricing;
                private CombinationPriceType combinationPricing;
                private SimpleCurrencyPrice simpleCurrencyPrice;
                private DetailCurrencyPriceType detailCurrencyPrice;
                private EncodedCurrencyPrice encodedCurrencyPrice;
                private String refs;

                private void setChoiceSelect(int choice) {
                    if (choiceSelect == -1) {
                        choiceSelect = choice;
                    } else if (choiceSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearChoiceSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearChoiceSelect() {
                    choiceSelect = -1;
                }

                /** 
                 * Check if AwardPricing is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAwardPricing() {
                    return choiceSelect == AWARD_PRICING_CHOICE;
                }

                /** 
                 * Get the 'AwardPricing' element value.
                 * 
                 * @return value
                 */
                public AwardPriceUnitType getAwardPricing() {
                    return awardPricing;
                }

                /** 
                 * Set the 'AwardPricing' element value.
                 * 
                 * @param awardPricing
                 */
                public void setAwardPricing(AwardPriceUnitType awardPricing) {
                    setChoiceSelect(AWARD_PRICING_CHOICE);
                    this.awardPricing = awardPricing;
                }

                /** 
                 * Check if CombinationPricing is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifCombinationPricing() {
                    return choiceSelect == COMBINATION_PRICING_CHOICE;
                }

                /** 
                 * Get the 'CombinationPricing' element value.
                 * 
                 * @return value
                 */
                public CombinationPriceType getCombinationPricing() {
                    return combinationPricing;
                }

                /** 
                 * Set the 'CombinationPricing' element value.
                 * 
                 * @param combinationPricing
                 */
                public void setCombinationPricing(
                        CombinationPriceType combinationPricing) {
                    setChoiceSelect(COMBINATION_PRICING_CHOICE);
                    this.combinationPricing = combinationPricing;
                }

                /** 
                 * Check if SimpleCurrencyPrice is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifSimpleCurrencyPrice() {
                    return choiceSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
                }

                /** 
                 * Get the 'SimpleCurrencyPrice' element value.
                 * 
                 * @return value
                 */
                public SimpleCurrencyPrice getSimpleCurrencyPrice() {
                    return simpleCurrencyPrice;
                }

                /** 
                 * Set the 'SimpleCurrencyPrice' element value.
                 * 
                 * @param simpleCurrencyPrice
                 */
                public void setSimpleCurrencyPrice(
                        SimpleCurrencyPrice simpleCurrencyPrice) {
                    setChoiceSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
                    this.simpleCurrencyPrice = simpleCurrencyPrice;
                }

                /** 
                 * Check if DetailCurrencyPrice is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifDetailCurrencyPrice() {
                    return choiceSelect == DETAIL_CURRENCY_PRICE_CHOICE;
                }

                /** 
                 * Get the 'DetailCurrencyPrice' element value.
                 * 
                 * @return value
                 */
                public DetailCurrencyPriceType getDetailCurrencyPrice() {
                    return detailCurrencyPrice;
                }

                /** 
                 * Set the 'DetailCurrencyPrice' element value.
                 * 
                 * @param detailCurrencyPrice
                 */
                public void setDetailCurrencyPrice(
                        DetailCurrencyPriceType detailCurrencyPrice) {
                    setChoiceSelect(DETAIL_CURRENCY_PRICE_CHOICE);
                    this.detailCurrencyPrice = detailCurrencyPrice;
                }

                /** 
                 * Check if EncodedCurrencyPrice is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifEncodedCurrencyPrice() {
                    return choiceSelect == ENCODED_CURRENCY_PRICE_CHOICE;
                }

                /** 
                 * Get the 'EncodedCurrencyPrice' element value.
                 * 
                 * @return value
                 */
                public EncodedCurrencyPrice getEncodedCurrencyPrice() {
                    return encodedCurrencyPrice;
                }

                /** 
                 * Set the 'EncodedCurrencyPrice' element value.
                 * 
                 * @param encodedCurrencyPrice
                 */
                public void setEncodedCurrencyPrice(
                        EncodedCurrencyPrice encodedCurrencyPrice) {
                    setChoiceSelect(ENCODED_CURRENCY_PRICE_CHOICE);
                    this.encodedCurrencyPrice = encodedCurrencyPrice;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
            /** 
             * Associated Service Item(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedServices" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AssociatedService" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class AssociatedService -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AssociatedServices implements Serializable
            {
                private List<AssociatedService> associatedServiceList = new ArrayList<AssociatedService>();

                /** 
                 * Get the list of 'AssociatedService' element items.
                 * 
                 * @return list
                 */
                public List<AssociatedService> getAssociatedServiceList() {
                    return associatedServiceList;
                }

                /** 
                 * Set the list of 'AssociatedService' element items.
                 * 
                 * @param list
                 */
                public void setAssociatedServiceList(
                        List<AssociatedService> list) {
                    associatedServiceList = list;
                }
                /** 
                 * Offer Item ID with optional passenger association.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedService" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:complexContent>
                 *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
                 *         &lt;xs:sequence>
                 *           &lt;xs:element ref="ns:ServiceID" minOccurs="0"/>
                 *           &lt;xs:element name="Passengers" minOccurs="0">
                 *             &lt;xs:complexType>
                 *               &lt;xs:sequence>
                 *                 &lt;xs:element ref="ns:PassengerReference"/>
                 *               &lt;/xs:sequence>
                 *             &lt;/xs:complexType>
                 *           &lt;/xs:element>
                 *         &lt;/xs:sequence>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:complexContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AssociatedService
                        extends
                            AssociatedObjectBaseType implements Serializable
                {
                    private ServiceIDType serviceID;
                    private PassengerReference passengers;

                    /** 
                     * Get the 'ServiceID' element value.
                     * 
                     * @return value
                     */
                    public ServiceIDType getServiceID() {
                        return serviceID;
                    }

                    /** 
                     * Set the 'ServiceID' element value.
                     * 
                     * @param serviceID
                     */
                    public void setServiceID(ServiceIDType serviceID) {
                        this.serviceID = serviceID;
                    }

                    /** 
                     * Get the 'PassengerReference' element value. 
                                                Association to multiple Passenger instance(s). Example: pax1 pax2
                                              
                     * 
                     * @return value
                     */
                    public PassengerReference getPassengers() {
                        return passengers;
                    }

                    /** 
                     * Set the 'PassengerReference' element value. 
                                                Association to multiple Passenger instance(s). Example: pax1 pax2
                                              
                     * 
                     * @param passengers
                     */
                    public void setPassengers(PassengerReference passengers) {
                        this.passengers = passengers;
                    }
                }
            }
            /** 
             * 
                                      Offer Item details including wait list indicator and inventory guarantee.
                                    
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Details" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="InventoryGuarantee" minOccurs="0">
             *         &lt;!-- Reference to inner class InventoryGuarantee -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="WaitListInd"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Details implements Serializable
            {
                private InventoryGuarantee inventoryGuarantee;
                private Boolean waitListInd;

                /** 
                 * Get the 'InventoryGuarantee' element value.
                 * 
                 * @return value
                 */
                public InventoryGuarantee getInventoryGuarantee() {
                    return inventoryGuarantee;
                }

                /** 
                 * Set the 'InventoryGuarantee' element value.
                 * 
                 * @param inventoryGuarantee
                 */
                public void setInventoryGuarantee(
                        InventoryGuarantee inventoryGuarantee) {
                    this.inventoryGuarantee = inventoryGuarantee;
                }

                /** 
                 * Get the 'WaitListInd' attribute value. When TRUE, this offer item is waitlisted.
                 * 
                 * @return value
                 */
                public Boolean getWaitListInd() {
                    return waitListInd;
                }

                /** 
                 * Set the 'WaitListInd' attribute value. When TRUE, this offer item is waitlisted.
                 * 
                 * @param waitListInd
                 */
                public void setWaitListInd(Boolean waitListInd) {
                    this.waitListInd = waitListInd;
                }
                /** 
                 * Inventory Guarantee 
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InventoryGuarantee" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="InvGuaranteeID"/>
                 *       &lt;xs:element ref="ns:InvGuaranteeTimeLimits"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class InventoryGuarantee implements Serializable
                {
                    private String invGuaranteeID;
                    private CoreDateGrpType invGuaranteeTimeLimits;

                    /** 
                     * Get the 'InvGuaranteeID' element value. 
                                                      Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                                    
                     * 
                     * @return value
                     */
                    public String getInvGuaranteeID() {
                        return invGuaranteeID;
                    }

                    /** 
                     * Set the 'InvGuaranteeID' element value. 
                                                      Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                                    
                     * 
                     * @param invGuaranteeID
                     */
                    public void setInvGuaranteeID(String invGuaranteeID) {
                        this.invGuaranteeID = invGuaranteeID;
                    }

                    /** 
                     * Get the 'InvGuaranteeTimeLimits' element value. Time limit by which guaranteed inventory for a specified product offer is guaranteed as available and by which the inventory held must be converted into a completed order before the time limit expires otherwise the guarantee is lost.

                    Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z
                     * 
                     * @return value
                     */
                    public CoreDateGrpType getInvGuaranteeTimeLimits() {
                        return invGuaranteeTimeLimits;
                    }

                    /** 
                     * Set the 'InvGuaranteeTimeLimits' element value. Time limit by which guaranteed inventory for a specified product offer is guaranteed as available and by which the inventory held must be converted into a completed order before the time limit expires otherwise the guarantee is lost.

                    Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z
                     * 
                     * @param invGuaranteeTimeLimits
                     */
                    public void setInvGuaranteeTimeLimits(
                            CoreDateGrpType invGuaranteeTimeLimits) {
                        this.invGuaranteeTimeLimits = invGuaranteeTimeLimits;
                    }
                }
            }
        }
        /** 
         * The total price for all Travelers associated with this offer.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalPrice" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element ref="ns:AwardPricing"/>
         *       &lt;xs:element ref="ns:CombinationPricing"/>
         *       &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
         *       &lt;xs:element ref="ns:DetailCurrencyPrice"/>
         *       &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
         *     &lt;/xs:choice>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class TotalPrice implements Serializable
        {
            private int choiceSelect = -1;
            private static final int AWARD_PRICING_CHOICE = 0;
            private static final int COMBINATION_PRICING_CHOICE = 1;
            private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 2;
            private static final int DETAIL_CURRENCY_PRICE_CHOICE = 3;
            private static final int ENCODED_CURRENCY_PRICE_CHOICE = 4;
            private AwardPriceUnitType awardPricing;
            private CombinationPriceType combinationPricing;
            private SimpleCurrencyPrice simpleCurrencyPrice;
            private DetailCurrencyPriceType detailCurrencyPrice;
            private EncodedCurrencyPrice encodedCurrencyPrice;
            private String refs;

            private void setChoiceSelect(int choice) {
                if (choiceSelect == -1) {
                    choiceSelect = choice;
                } else if (choiceSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceSelect() {
                choiceSelect = -1;
            }

            /** 
             * Check if AwardPricing is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAwardPricing() {
                return choiceSelect == AWARD_PRICING_CHOICE;
            }

            /** 
             * Get the 'AwardPricing' element value.
             * 
             * @return value
             */
            public AwardPriceUnitType getAwardPricing() {
                return awardPricing;
            }

            /** 
             * Set the 'AwardPricing' element value.
             * 
             * @param awardPricing
             */
            public void setAwardPricing(AwardPriceUnitType awardPricing) {
                setChoiceSelect(AWARD_PRICING_CHOICE);
                this.awardPricing = awardPricing;
            }

            /** 
             * Check if CombinationPricing is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCombinationPricing() {
                return choiceSelect == COMBINATION_PRICING_CHOICE;
            }

            /** 
             * Get the 'CombinationPricing' element value.
             * 
             * @return value
             */
            public CombinationPriceType getCombinationPricing() {
                return combinationPricing;
            }

            /** 
             * Set the 'CombinationPricing' element value.
             * 
             * @param combinationPricing
             */
            public void setCombinationPricing(
                    CombinationPriceType combinationPricing) {
                setChoiceSelect(COMBINATION_PRICING_CHOICE);
                this.combinationPricing = combinationPricing;
            }

            /** 
             * Check if SimpleCurrencyPrice is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSimpleCurrencyPrice() {
                return choiceSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
            }

            /** 
             * Get the 'SimpleCurrencyPrice' element value.
             * 
             * @return value
             */
            public SimpleCurrencyPrice getSimpleCurrencyPrice() {
                return simpleCurrencyPrice;
            }

            /** 
             * Set the 'SimpleCurrencyPrice' element value.
             * 
             * @param simpleCurrencyPrice
             */
            public void setSimpleCurrencyPrice(
                    SimpleCurrencyPrice simpleCurrencyPrice) {
                setChoiceSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
                this.simpleCurrencyPrice = simpleCurrencyPrice;
            }

            /** 
             * Check if DetailCurrencyPrice is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifDetailCurrencyPrice() {
                return choiceSelect == DETAIL_CURRENCY_PRICE_CHOICE;
            }

            /** 
             * Get the 'DetailCurrencyPrice' element value.
             * 
             * @return value
             */
            public DetailCurrencyPriceType getDetailCurrencyPrice() {
                return detailCurrencyPrice;
            }

            /** 
             * Set the 'DetailCurrencyPrice' element value.
             * 
             * @param detailCurrencyPrice
             */
            public void setDetailCurrencyPrice(
                    DetailCurrencyPriceType detailCurrencyPrice) {
                setChoiceSelect(DETAIL_CURRENCY_PRICE_CHOICE);
                this.detailCurrencyPrice = detailCurrencyPrice;
            }

            /** 
             * Check if EncodedCurrencyPrice is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifEncodedCurrencyPrice() {
                return choiceSelect == ENCODED_CURRENCY_PRICE_CHOICE;
            }

            /** 
             * Get the 'EncodedCurrencyPrice' element value.
             * 
             * @return value
             */
            public EncodedCurrencyPrice getEncodedCurrencyPrice() {
                return encodedCurrencyPrice;
            }

            /** 
             * Set the 'EncodedCurrencyPrice' element value.
             * 
             * @param encodedCurrencyPrice
             */
            public void setEncodedCurrencyPrice(
                    EncodedCurrencyPrice encodedCurrencyPrice) {
                setChoiceSelect(ENCODED_CURRENCY_PRICE_CHOICE);
                this.encodedCurrencyPrice = encodedCurrencyPrice;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
    }
}
