
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * GENERIC/ IATA SPECIAL SERVICE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Code"/>
 *         &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="DescContext" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SpecialType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private String code;
    private String description;
    private String descContext;

    /** 
     * Get the 'Code' element value. Special service/ request code value.

    Example: UMNR (IATA passenger assistance SSR code)

    Encoding Scheme: Use of IATA Special Service Request (SSR) Code encoding is recommended. Any string value up to 15 characters in length is valid.

    Note: Although optional in the schema, some SSR codes may require associated description and description codes.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Special service/ request code value.

    Example: UMNR (IATA passenger assistance SSR code)

    Encoding Scheme: Use of IATA Special Service Request (SSR) Code encoding is recommended. Any string value up to 15 characters in length is valid.

    Note: Although optional in the schema, some SSR codes may require associated description and description codes.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'Description' element value. Code description. Example: Unaccompanied Minor
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Code description. Example: Unaccompanied Minor
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'DescContext' element value. Description context. Examples: WEIGHT, NUMBER, PEDICURE
     * 
     * @return value
     */
    public String getDescContext() {
        return descContext;
    }

    /** 
     * Set the 'DescContext' element value. Description context. Examples: WEIGHT, NUMBER, PEDICURE
     * 
     * @param descContext
     */
    public void setDescContext(String descContext) {
        this.descContext = descContext;
    }
}
