
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;

/** 
 * A data type for Start and End Date Range with Minimum/ Maximum Stay Duration.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StayPeriodDateRangeType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:date" name="StartDate"/>
 *         &lt;xs:element type="xs:date" name="EndDate"/>
 *         &lt;xs:element type="xs:string" name="MinimumStay" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="MaximumStay" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StayPeriodDateRangeType extends KeyWithMetaObjectBaseType
    implements Serializable
{
    private Date startDate;
    private Date endDate;
    private String minimumStay;
    private String maximumStay;

    /** 
     * Get the 'StartDate' element value. Starting Date of the stay period range. Example: 2016-01-13
     * 
     * @return value
     */
    public Date getStartDate() {
        return startDate;
    }

    /** 
     * Set the 'StartDate' element value. Starting Date of the stay period range. Example: 2016-01-13
     * 
     * @param startDate
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    /** 
     * Get the 'EndDate' element value. Ending Date of the stay period range. Example: 2016-03-13
     * 
     * @return value
     */
    public Date getEndDate() {
        return endDate;
    }

    /** 
     * Set the 'EndDate' element value. Ending Date of the stay period range. Example: 2016-03-13
     * 
     * @param endDate
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    /** 
     * Get the 'MinimumStay' element value. Minimum Stay Period within the specified date range.
    Examples: P5D (five days)
     * 
     * @return value
     */
    public String getMinimumStay() {
        return minimumStay;
    }

    /** 
     * Set the 'MinimumStay' element value. Minimum Stay Period within the specified date range.
    Examples: P5D (five days)
     * 
     * @param minimumStay
     */
    public void setMinimumStay(String minimumStay) {
        this.minimumStay = minimumStay;
    }

    /** 
     * Get the 'MaximumStay' element value. Maximum Stay Period within the specified date range.
    Example: P10D (ten days)
     * 
     * @return value
     */
    public String getMaximumStay() {
        return maximumStay;
    }

    /** 
     * Set the 'MaximumStay' element value. Maximum Stay Period within the specified date range.
    Example: P10D (ten days)
     * 
     * @param maximumStay
     */
    public void setMaximumStay(String maximumStay) {
        this.maximumStay = maximumStay;
    }
}
