
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Season (Months/ Quarters) with Minimum/ Maximum Stay Duration.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StayPeriodSeasonType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:choice>
 *           &lt;xs:element ref="ns:Month" maxOccurs="12"/>
 *           &lt;xs:element ref="ns:QuarterPeriod" maxOccurs="4"/>
 *         &lt;/xs:choice>
 *         &lt;xs:element type="xs:string" name="MinimumStay"/>
 *         &lt;xs:element type="xs:string" name="MaximumStay"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StayPeriodSeasonType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private int choiceSelect = -1;
    private static final int MONTH_LIST_CHOICE = 0;
    private static final int QUARTER_PERIOD_LIST_CHOICE = 1;
    private List<MonthRepType> monthList = new ArrayList<MonthRepType>();
    private List<QuarterPeriodRepType> quarterPeriodList = new ArrayList<QuarterPeriodRepType>();
    private String minimumStay;
    private String maximumStay;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if MonthList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMonthList() {
        return choiceSelect == MONTH_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Month' element items.
     * 
     * @return list
     */
    public List<MonthRepType> getMonthList() {
        return monthList;
    }

    /** 
     * Set the list of 'Month' element items.
     * 
     * @param list
     */
    public void setMonthList(List<MonthRepType> list) {
        setChoiceSelect(MONTH_LIST_CHOICE);
        monthList = list;
    }

    /** 
     * Check if QuarterPeriodList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQuarterPeriodList() {
        return choiceSelect == QUARTER_PERIOD_LIST_CHOICE;
    }

    /** 
     * Get the list of 'QuarterPeriod' element items.
     * 
     * @return list
     */
    public List<QuarterPeriodRepType> getQuarterPeriodList() {
        return quarterPeriodList;
    }

    /** 
     * Set the list of 'QuarterPeriod' element items.
     * 
     * @param list
     */
    public void setQuarterPeriodList(List<QuarterPeriodRepType> list) {
        setChoiceSelect(QUARTER_PERIOD_LIST_CHOICE);
        quarterPeriodList = list;
    }

    /** 
     * Get the 'MinimumStay' element value. Minimum Stay Period within the specified calendar season.
    Examples: P5D (five days)
     * 
     * @return value
     */
    public String getMinimumStay() {
        return minimumStay;
    }

    /** 
     * Set the 'MinimumStay' element value. Minimum Stay Period within the specified calendar season.
    Examples: P5D (five days)
     * 
     * @param minimumStay
     */
    public void setMinimumStay(String minimumStay) {
        this.minimumStay = minimumStay;
    }

    /** 
     * Get the 'MaximumStay' element value. Maximum Stay Period within the specified calendar season.
    Example: P10D (ten days)
     * 
     * @return value
     */
    public String getMaximumStay() {
        return maximumStay;
    }

    /** 
     * Set the 'MaximumStay' element value. Maximum Stay Period within the specified calendar season.
    Example: P10D (ten days)
     * 
     * @param maximumStay
     */
    public void setMaximumStay(String maximumStay) {
        this.maximumStay = maximumStay;
    }
}
