
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * STRUCTURED ADDRESS representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StructuredAddrType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Application" minOccurs="0">
 *           &lt;xs:simpleType>
 *             &lt;!-- Reference to inner class Application -->
 *           &lt;/xs:simpleType>
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="Street" minOccurs="0" maxOccurs="2"/>
 *         &lt;xs:element type="xs:string" name="BuildingRoom" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="PO_Box" minOccurs="0"/>
 *         &lt;xs:element ref="ns:CityName" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="StateProv" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
 *         &lt;xs:element ref="ns:CountryCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="County" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StructuredAddrType extends AssociatedObjectBaseType implements
    Serializable
{
    private Application application;
    private List<String> streetList = new ArrayList<String>();
    private String buildingRoom;
    private String POBox;
    private CityName cityName;
    private String stateProv;
    private String postalCode;
    private CountryCodeType countryCode;
    private String county;

    /** 
     * Get the 'Application' element value. AddressAtOrigin or AddressAtDestination
     * 
     * @return value
     */
    public Application getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. AddressAtOrigin or AddressAtDestination
     * 
     * @param application
     */
    public void setApplication(Application application) {
        this.application = application;
    }

    /** 
     * Get the list of 'Street' element items. Street. Examples: Main Street, 100 Main Street
     * 
     * @return list
     */
    public List<String> getStreetList() {
        return streetList;
    }

    /** 
     * Set the list of 'Street' element items. Street. Examples: Main Street, 100 Main Street
     * 
     * @param list
     */
    public void setStreetList(List<String> list) {
        streetList = list;
    }

    /** 
     * Get the 'BuildingRoom' element value. Building name, room, apartment, or suite number.
     * 
     * @return value
     */
    public String getBuildingRoom() {
        return buildingRoom;
    }

    /** 
     * Set the 'BuildingRoom' element value. Building name, room, apartment, or suite number.
     * 
     * @param buildingRoom
     */
    public void setBuildingRoom(String buildingRoom) {
        this.buildingRoom = buildingRoom;
    }

    /** 
     * Get the 'PO_Box' element value. Post office box. Example: P.O. Box 21
     * 
     * @return value
     */
    public String getPOBox() {
        return POBox;
    }

    /** 
     * Set the 'PO_Box' element value. Post office box. Example: P.O. Box 21
     * 
     * @param POBox
     */
    public void setPOBox(String POBox) {
        this.POBox = POBox;
    }

    /** 
     * Get the 'CityName' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address).
     * 
     * @return value
     */
    public CityName getCityName() {
        return cityName;
    }

    /** 
     * Set the 'CityName' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address).
     * 
     * @param cityName
     */
    public void setCityName(CityName cityName) {
        this.cityName = cityName;
    }

    /** 
     * Get the 'StateProv' element value. State or province code. Examples: NY, QUE
     * 
     * @return value
     */
    public String getStateProv() {
        return stateProv;
    }

    /** 
     * Set the 'StateProv' element value. State or province code. Examples: NY, QUE
     * 
     * @param stateProv
     */
    public void setStateProv(String stateProv) {
        this.stateProv = stateProv;
    }

    /** 
     * Get the 'PostalCode' element value. Postal code. Examples: 11001, 11001-2345
     * 
     * @return value
     */
    public String getPostalCode() {
        return postalCode;
    }

    /** 
     * Set the 'PostalCode' element value. Postal code. Examples: 11001, 11001-2345
     * 
     * @param postalCode
     */
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    /** 
     * Get the 'CountryCode' element value.
     * 
     * @return value
     */
    public CountryCodeType getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value.
     * 
     * @param countryCode
     */
    public void setCountryCode(CountryCodeType countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'County' element value. County that the address is located in. Example: Litchfield
     * 
     * @return value
     */
    public String getCounty() {
        return county;
    }

    /** 
     * Set the 'County' element value. County that the address is located in. Example: Litchfield
     * 
     * @param county
     */
    public void setCounty(String county) {
        this.county = county;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="AddressAtOrigin"/>
     *     &lt;xs:enumeration value="AddressAtDestination"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Application implements Serializable {
        ADDRESS_AT_ORIGIN("AddressAtOrigin"), ADDRESS_AT_DESTINATION(
                "AddressAtDestination");
        private final String value;

        private Application(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Application convert(String value) {
            for (Application inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
