
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * TAX CORE representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxCoreType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="ApproxInd"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="CollectionInd"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="RefundAllInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TaxCoreType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private Boolean approxInd;
    private Boolean collectionInd;
    private Boolean refundAllInd;

    /** 
     * Get the 'ApproxInd' attribute value. When TRUE, this tax is approximate.
     * 
     * @return value
     */
    public Boolean getApproxInd() {
        return approxInd;
    }

    /** 
     * Set the 'ApproxInd' attribute value. When TRUE, this tax is approximate.
     * 
     * @param approxInd
     */
    public void setApproxInd(Boolean approxInd) {
        this.approxInd = approxInd;
    }

    /** 
     * Get the 'CollectionInd' attribute value. When TRUE, this tax must be collected.
     * 
     * @return value
     */
    public Boolean getCollectionInd() {
        return collectionInd;
    }

    /** 
     * Set the 'CollectionInd' attribute value. When TRUE, this tax must be collected.
     * 
     * @param collectionInd
     */
    public void setCollectionInd(Boolean collectionInd) {
        this.collectionInd = collectionInd;
    }

    /** 
     * Get the 'RefundAllInd' attribute value. When TRUE, all tax amounts are refundable.
     * 
     * @return value
     */
    public Boolean getRefundAllInd() {
        return refundAllInd;
    }

    /** 
     * Set the 'RefundAllInd' attribute value. When TRUE, all tax amounts are refundable.
     * 
     * @param refundAllInd
     */
    public void setRefundAllInd(Boolean refundAllInd) {
        this.refundAllInd = refundAllInd;
    }
}
