
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * 
 Pricing-related Fee and Tax Exemption Notice definition.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxExemptionNoticeType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TrxProcessObjectBaseType">
 *       &lt;xs:choice>
 *         &lt;xs:element name="Query">
 *           &lt;!-- Reference to inner class Query -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Results">
 *           &lt;!-- Reference to inner class Results -->
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TaxExemptionNoticeType extends TrxProcessObjectBaseType implements
    Serializable
{
    private int choiceSelect = -1;
    private static final int QUERY_CHOICE = 0;
    private static final int RESULTS_CHOICE = 1;
    private Query query;
    private Results results;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Query is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQuery() {
        return choiceSelect == QUERY_CHOICE;
    }

    /** 
     * Get the 'Query' element value.
     * 
     * @return value
     */
    public Query getQuery() {
        return query;
    }

    /** 
     * Set the 'Query' element value.
     * 
     * @param query
     */
    public void setQuery(Query query) {
        setChoiceSelect(QUERY_CHOICE);
        this.query = query;
    }

    /** 
     * Check if Results is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifResults() {
        return choiceSelect == RESULTS_CHOICE;
    }

    /** 
     * Get the 'Results' element value.
     * 
     * @return value
     */
    public Results getResults() {
        return results;
    }

    /** 
     * Set the 'Results' element value.
     * 
     * @param results
     */
    public void setResults(Results results) {
        setChoiceSelect(RESULTS_CHOICE);
        this.results = results;
    }
    /** 
     * Exemption Rule(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Query">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Named" minOccurs="0">
     *         &lt;!-- Reference to inner class Named -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:RuleSetType" name="Rules" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ExemptAllInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Query implements Serializable
    {
        private Named named;
        private RuleSetType rules;
        private Boolean exemptAllInd;

        /** 
         * Get the 'Named' element value.
         * 
         * @return value
         */
        public Named getNamed() {
            return named;
        }

        /** 
         * Set the 'Named' element value.
         * 
         * @param named
         */
        public void setNamed(Named named) {
            this.named = named;
        }

        /** 
         * Get the 'Rules' element value. Additional Tax Exemption Rule(s).
         * 
         * @return value
         */
        public RuleSetType getRules() {
            return rules;
        }

        /** 
         * Set the 'Rules' element value. Additional Tax Exemption Rule(s).
         * 
         * @param rules
         */
        public void setRules(RuleSetType rules) {
            this.rules = rules;
        }

        /** 
         * Get the 'ExemptAllInd' attribute value. When TRUE, all pricing is tax/ fee exempt.
         * 
         * @return value
         */
        public Boolean getExemptAllInd() {
            return exemptAllInd;
        }

        /** 
         * Set the 'ExemptAllInd' attribute value. When TRUE, all pricing is tax/ fee exempt.
         * 
         * @param exemptAllInd
         */
        public void setExemptAllInd(Boolean exemptAllInd) {
            this.exemptAllInd = exemptAllInd;
        }
        /** 
         * 
                          Named Tax Exemptions, including Country(s), Entity(s), Territory(s) and Tax Code(s).
                        
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Named" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Countries" minOccurs="0">
         *         &lt;!-- Reference to inner class Countries -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Entities" minOccurs="0">
         *         &lt;!-- Reference to inner class Entities -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Territories" minOccurs="0">
         *         &lt;!-- Reference to inner class Territories -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TaxCodes" minOccurs="0">
         *         &lt;!-- Reference to inner class TaxCodes -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Named implements Serializable
        {
            private Countries countries;
            private Entities entities;
            private Territories territories;
            private TaxCodes taxCodes;

            /** 
             * Get the 'Countries' element value.
             * 
             * @return value
             */
            public Countries getCountries() {
                return countries;
            }

            /** 
             * Set the 'Countries' element value.
             * 
             * @param countries
             */
            public void setCountries(Countries countries) {
                this.countries = countries;
            }

            /** 
             * Get the 'Entities' element value.
             * 
             * @return value
             */
            public Entities getEntities() {
                return entities;
            }

            /** 
             * Set the 'Entities' element value.
             * 
             * @param entities
             */
            public void setEntities(Entities entities) {
                this.entities = entities;
            }

            /** 
             * Get the 'Territories' element value.
             * 
             * @return value
             */
            public Territories getTerritories() {
                return territories;
            }

            /** 
             * Set the 'Territories' element value.
             * 
             * @param territories
             */
            public void setTerritories(Territories territories) {
                this.territories = territories;
            }

            /** 
             * Get the 'TaxCodes' element value.
             * 
             * @return value
             */
            public TaxCodes getTaxCodes() {
                return taxCodes;
            }

            /** 
             * Set the 'TaxCodes' element value.
             * 
             * @param taxCodes
             */
            public void setTaxCodes(TaxCodes taxCodes) {
                this.taxCodes = taxCodes;
            }
            /** 
             * Exempt tax country information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Countries" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:CountryCode" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Countries implements Serializable
            {
                private List<CountryCodeType> countryCodeList = new ArrayList<CountryCodeType>();

                /** 
                 * Get the list of 'CountryCode' element items.
                 * 
                 * @return list
                 */
                public List<CountryCodeType> getCountryCodeList() {
                    return countryCodeList;
                }

                /** 
                 * Set the list of 'CountryCode' element items.
                 * 
                 * @param list
                 */
                public void setCountryCodeList(List<CountryCodeType> list) {
                    countryCodeList = list;
                }
            }
            /** 
             * Name of entity to which passenger belongs, indicating an exemption to the application of a tax.

            Example: Military, Government
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Entities" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Entity" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Entities implements Serializable
            {
                private List<String> entityList = new ArrayList<String>();

                /** 
                 * Get the list of 'Entity' element items. Exempt tax entity name. Example: Military, IBM
                 * 
                 * @return list
                 */
                public List<String> getEntityList() {
                    return entityList;
                }

                /** 
                 * Set the list of 'Entity' element items. Exempt tax entity name. Example: Military, IBM
                 * 
                 * @param list
                 */
                public void setEntityList(List<String> list) {
                    entityList = list;
                }
            }
            /** 
             * Name or code of state or territory used to identify tax exemptions.

            Codes are published in Appendix C of IATA AIRIMP.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Territories" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Territory" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Territories implements Serializable
            {
                private List<String> territoryList = new ArrayList<String>();

                /** 
                 * Get the list of 'Territory' element items. 
                                          Exempt tax province/ territory name or code. Example: QC
                                        
                 * 
                 * @return list
                 */
                public List<String> getTerritoryList() {
                    return territoryList;
                }

                /** 
                 * Set the list of 'Territory' element items. 
                                          Exempt tax province/ territory name or code. Example: QC
                                        
                 * 
                 * @param list
                 */
                public void setTerritoryList(List<String> list) {
                    territoryList = list;
                }
            }
            /** 
             * 
                                  Exempt Tax Code(s). Note: This contains tax exemption(s) based on tax designator and nature.
                                
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxCodes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="TaxCode" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class TaxCode -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TaxCodes implements Serializable
            {
                private List<TaxCode> taxCodeList = new ArrayList<TaxCode>();

                /** 
                 * Get the list of 'TaxCode' element items.
                 * 
                 * @return list
                 */
                public List<TaxCode> getTaxCodeList() {
                    return taxCodeList;
                }

                /** 
                 * Set the list of 'TaxCode' element items.
                 * 
                 * @param list
                 */
                public void setTaxCodeList(List<TaxCode> list) {
                    taxCodeList = list;
                }
                /** 
                 * Tax Code detail.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxCode" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Designator"/>
                 *       &lt;xs:element type="xs:string" name="Nature" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxCode implements Serializable
                {
                    private String designator;
                    private String nature;

                    /** 
                     * Get the 'Designator' element value. Tax designator. Example: XY
                     * 
                     * @return value
                     */
                    public String getDesignator() {
                        return designator;
                    }

                    /** 
                     * Set the 'Designator' element value. Tax designator. Example: XY
                     * 
                     * @param designator
                     */
                    public void setDesignator(String designator) {
                        this.designator = designator;
                    }

                    /** 
                     * Get the 'Nature' element value. Tax nature. Example: I
                     * 
                     * @return value
                     */
                    public String getNature() {
                        return nature;
                    }

                    /** 
                     * Set the 'Nature' element value. Tax nature. Example: I
                     * 
                     * @param nature
                     */
                    public void setNature(String nature) {
                        this.nature = nature;
                    }
                }
            }
        }
    }
    /** 
     * 
                  Exemption Rule(s) applied during transaction processing.
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Results">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TaxExemption" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class TaxExemption -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ExemptionAppliedInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Results implements Serializable
    {
        private List<TaxExemption> taxExemptionList = new ArrayList<TaxExemption>();
        private Boolean exemptionAppliedInd;

        /** 
         * Get the list of 'TaxExemption' element items.
         * 
         * @return list
         */
        public List<TaxExemption> getTaxExemptionList() {
            return taxExemptionList;
        }

        /** 
         * Set the list of 'TaxExemption' element items.
         * 
         * @param list
         */
        public void setTaxExemptionList(List<TaxExemption> list) {
            taxExemptionList = list;
        }

        /** 
         * Get the 'ExemptionAppliedInd' attribute value. 
                        When TRUE, a tax/ fee exemption was applied to the total order price or one or more priced Order Items.
                      
         * 
         * @return value
         */
        public Boolean getExemptionAppliedInd() {
            return exemptionAppliedInd;
        }

        /** 
         * Set the 'ExemptionAppliedInd' attribute value. 
                        When TRUE, a tax/ fee exemption was applied to the total order price or one or more priced Order Items.
                      
         * 
         * @param exemptionAppliedInd
         */
        public void setExemptionAppliedInd(Boolean exemptionAppliedInd) {
            this.exemptionAppliedInd = exemptionAppliedInd;
        }
        /** 
         * Applied Tax Exemption(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxExemption" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="RuleID" minOccurs="0">
         *         &lt;!-- Reference to inner class RuleID -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:Associations" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TaxExemption implements Serializable
        {
            private RuleID ruleID;
            private Associations associations;

            /** 
             * Get the 'RuleID' element value.
             * 
             * @return value
             */
            public RuleID getRuleID() {
                return ruleID;
            }

            /** 
             * Set the 'RuleID' element value.
             * 
             * @param ruleID
             */
            public void setRuleID(RuleID ruleID) {
                this.ruleID = ruleID;
            }

            /** 
             * Get the 'Associations' element value. 
                                  Order ID, Order Item and other associations where a price variance was applied.
                                
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value. 
                                  Order ID, Order Item and other associations where a price variance was applied.
                                
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }
            /** 
             * Unique Rule ID which was applied during transaction processing. Example: PRICERULE001 Note: Optional rule context and name may also be specified.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleID" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *         &lt;xs:attribute type="xs:anySimpleType" name="Name"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RuleID implements Serializable
            {
                private String string;
                private String context;
                private String name;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Rule ID Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Rule ID Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }

                /** 
                 * Get the 'Name' attribute value. 
                                            Rule Name. Example: Acceptable Order Item Price Variance
                                          
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' attribute value. 
                                            Rule Name. Example: Acceptable Order Item Price Variance
                                          
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }
            }
        }
    }
}
