
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * COUPON TICKET DOCUMENT definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocHistoryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TicketDocNbr"/>
 *     &lt;xs:element type="ns:CodesetType" name="Type" minOccurs="0"/>
 *     &lt;xs:element type="ns:HistoryCouponInfoType" name="CouponInfo" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketDocHistoryType implements Serializable
{
    private String ticketDocNbr;
    private CodesetType type;
    private List<HistoryCouponInfoType> couponInfoList = new ArrayList<HistoryCouponInfoType>();

    /** 
     * Get the 'TicketDocNbr' element value. Coupon Document Number.

    Note: This is the document number comprised of the airline code, form code, and serial number.
     * 
     * @return value
     */
    public String getTicketDocNbr() {
        return ticketDocNbr;
    }

    /** 
     * Set the 'TicketDocNbr' element value. Coupon Document Number.

    Note: This is the document number comprised of the airline code, form code, and serial number.
     * 
     * @param ticketDocNbr
     */
    public void setTicketDocNbr(String ticketDocNbr) {
        this.ticketDocNbr = ticketDocNbr;
    }

    /** 
     * Get the 'Type' element value. Coupon Type. Example: Y (EMD-S Standalone)

    Encoding Scheme: IATA Padis Codeset - List for data element 1001 (Document/ Message Name, coded)
     * 
     * @return value
     */
    public CodesetType getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Coupon Type. Example: Y (EMD-S Standalone)

    Encoding Scheme: IATA Padis Codeset - List for data element 1001 (Document/ Message Name, coded)
     * 
     * @param type
     */
    public void setType(CodesetType type) {
        this.type = type;
    }

    /** 
     * Get the list of 'CouponInfo' element items. Coupon information.
     * 
     * @return list
     */
    public List<HistoryCouponInfoType> getCouponInfoList() {
        return couponInfoList;
    }

    /** 
     * Set the list of 'CouponInfo' element items. Coupon information.
     * 
     * @param list
     */
    public void setCouponInfoList(List<HistoryCouponInfoType> list) {
        couponInfoList = list;
    }
}
