
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * The document number, type and coupon numbers. 

 The following codes are used for new documents being issued: 
 J = EMD-A
 T = Ticket
 Y = EMD-Stand-alone

 The following codes are used to identify documents with exchange value being exchanged or reissued:
 A =  All Other Document Types
 E = Excess Baggage
 J = EMD-A
 M = MCO
 O = Tour Order
 S = Special Service Ticket
 T = Ticket
 Y = EMD-Stand-alone

 "

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TicketDocNbr"/>
 *     &lt;xs:element type="ns:CodesetType" name="Type"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketType implements Serializable
{
    private String ticketDocNbr;
    private CodesetType type;

    /** 
     * Get the 'TicketDocNbr' element value. The ticket/document number.
     * 
     * @return value
     */
    public String getTicketDocNbr() {
        return ticketDocNbr;
    }

    /** 
     * Set the 'TicketDocNbr' element value. The ticket/document number.
     * 
     * @param ticketDocNbr
     */
    public void setTicketDocNbr(String ticketDocNbr) {
        this.ticketDocNbr = ticketDocNbr;
    }

    /** 
     * Get the 'Type' element value. The type of ticket/document.

    Encoding Scheme: IATA Padis Codeset - List for data element 1001 (Document/ Message Name, coded)
     * 
     * @return value
     */
    public CodesetType getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. The type of ticket/document.

    Encoding Scheme: IATA Padis Codeset - List for data element 1001 (Document/ Message Name, coded)
     * 
     * @param type
     */
    public void setType(CodesetType type) {
        this.type = type;
    }
}
