
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for NDC Time Limit Type list constraint. Examples: Bilateral, Deposit, InventoryGuarantee, Naming, Offer, Payment, PriceGuarantee

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeLimitTypeListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Bilateral"/>
 *     &lt;xs:enumeration value="Deposit"/>
 *     &lt;xs:enumeration value="InventoryGuarantee"/>
 *     &lt;xs:enumeration value="Naming"/>
 *     &lt;xs:enumeration value="Offer"/>
 *     &lt;xs:enumeration value="Payment"/>
 *     &lt;xs:enumeration value="PriceGuarantee"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum TimeLimitTypeListType implements Serializable {
    BILATERAL("Bilateral"), DEPOSIT("Deposit"), INVENTORY_GUARANTEE(
            "InventoryGuarantee"), NAMING("Naming"), OFFER("Offer"), PAYMENT(
            "Payment"), PRICE_GUARANTEE("PriceGuarantee");
    private final String value;

    private TimeLimitTypeListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static TimeLimitTypeListType convert(String value) {
        for (TimeLimitTypeListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
