
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A data type for Travel Distance Preference.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelDistancePreferencesType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:decimal" name="DistanceAmount"/>
 *         &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="UOM" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelDistancePreferencesType extends AssociatedObjectBaseType
    implements Serializable
{
    private BigDecimal distanceAmount;
    private String application;
    private String UOM;
    private PreferenceAttrGroup preferenceAttrGroup;

    /** 
     * Get the 'DistanceAmount' element value. Travel Distance (unit) Value.  Example: 20
     * 
     * @return value
     */
    public BigDecimal getDistanceAmount() {
        return distanceAmount;
    }

    /** 
     * Set the 'DistanceAmount' element value. Travel Distance (unit) Value.  Example: 20
     * 
     * @param distanceAmount
     */
    public void setDistanceAmount(BigDecimal distanceAmount) {
        this.distanceAmount = distanceAmount;
    }

    /** 
     * Get the 'Application' element value. Travel distance application.
    Examples: TotalJourneyDistance, MaximumTravelDistance
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Travel distance application.
    Examples: TotalJourneyDistance, MaximumTravelDistance
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'UOM' element value. Distance unit of measure.  Example: Kilometers, Miles, Other
     * 
     * @return value
     */
    public String getUOM() {
        return UOM;
    }

    /** 
     * Set the 'UOM' element value. Distance unit of measure.  Example: Kilometers, Miles, Other
     * 
     * @param UOM
     */
    public void setUOM(String UOM) {
        this.UOM = UOM;
    }

    /** 
     * Get the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public PreferenceAttrGroup getPreferenceAttrGroup() {
        return preferenceAttrGroup;
    }

    /** 
     * Set the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @param preferenceAttrGroup
     */
    public void setPreferenceAttrGroup(PreferenceAttrGroup preferenceAttrGroup) {
        this.preferenceAttrGroup = preferenceAttrGroup;
    }
}
