
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * A data type for Traveler ACTORS, Core Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerCoreType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="PTC" minOccurs="0">
 *           &lt;!-- Reference to inner class PTC -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="ResidenceCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="PassengerAssociation" minOccurs="0"/>
 *         &lt;xs:element name="Age" minOccurs="0">
 *           &lt;!-- Reference to inner class Age -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="CitizenshipCountryCode" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelerCoreType extends KeyObjectBaseType implements Serializable
{
    private PTC PTC1;
    private String residenceCode;
    private String passengerAssociation;
    private Age age;
    private String citizenshipCountryCode;

    /** 
     * Get the 'PTC' element value.
     * 
     * @return value
     */
    public PTC getPTC1() {
        return PTC1;
    }

    /** 
     * Set the 'PTC' element value.
     * 
     * @param PTC1
     */
    public void setPTC1(PTC PTC1) {
        this.PTC1 = PTC1;
    }

    /** 
     * Get the 'ResidenceCode' element value. Residence country code.
    Examples: US, FR

    Encoding Scheme: ISO 3166-1 (two character) Country Code
     * 
     * @return value
     */
    public String getResidenceCode() {
        return residenceCode;
    }

    /** 
     * Set the 'ResidenceCode' element value. Residence country code.
    Examples: US, FR

    Encoding Scheme: ISO 3166-1 (two character) Country Code
     * 
     * @param residenceCode
     */
    public void setResidenceCode(String residenceCode) {
        this.residenceCode = residenceCode;
    }

    /** 
     * Get the 'PassengerAssociation' element value. Associate an infant in lap to an adult passenger
     * 
     * @return value
     */
    public String getPassengerAssociation() {
        return passengerAssociation;
    }

    /** 
     * Set the 'PassengerAssociation' element value. Associate an infant in lap to an adult passenger
     * 
     * @param passengerAssociation
     */
    public void setPassengerAssociation(String passengerAssociation) {
        this.passengerAssociation = passengerAssociation;
    }

    /** 
     * Get the 'Age' element value.
     * 
     * @return value
     */
    public Age getAge() {
        return age;
    }

    /** 
     * Set the 'Age' element value.
     * 
     * @param age
     */
    public void setAge(Age age) {
        this.age = age;
    }

    /** 
     * Get the 'CitizenshipCountryCode' element value. Citizenship country code.
    Examples: US, FR

    Encoding Scheme: ISO 3166-1 (two character) Country Code
     * 
     * @return value
     */
    public String getCitizenshipCountryCode() {
        return citizenshipCountryCode;
    }

    /** 
     * Set the 'CitizenshipCountryCode' element value. Citizenship country code.
    Examples: US, FR

    Encoding Scheme: ISO 3166-1 (two character) Country Code
     * 
     * @param citizenshipCountryCode
     */
    public void setCitizenshipCountryCode(String citizenshipCountryCode) {
        this.citizenshipCountryCode = citizenshipCountryCode;
    }
    /** 
     * Passenger type code and travelers quantity. 

    Example: ADT

    Encoding Scheme:  IATA (three character) Passenger Type Code
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PTC" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:integer" use="optional" name="Quantity"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PTC implements Serializable
    {
        private String string;
        private BigInteger quantity;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Quantity' attribute value. Number of Traveler(s) for associated passenger type and country of residence.
        Example: 2
         * 
         * @return value
         */
        public BigInteger getQuantity() {
            return quantity;
        }

        /** 
         * Set the 'Quantity' attribute value. Number of Traveler(s) for associated passenger type and country of residence.
        Example: 2
         * 
         * @param quantity
         */
        public void setQuantity(BigInteger quantity) {
            this.quantity = quantity;
        }
    }
    /** 
     * Age and/or birthdate.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Age" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element name="Value">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:string">
     *               &lt;xs:attribute type="ns:AgeUnitSimpleType" use="optional" name="UOM"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:date" name="BirthDate"/>
     *     &lt;/xs:choice>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Age implements Serializable
    {
        private int choiceSelect = -1;
        private static final int VALUE_CHOICE = 0;
        private static final int BIRTH_DATE_CHOICE = 1;
        private String valueString;
        private AgeUnitSimpleType valueUOM;
        private Date birthDate;
        private String refs;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Value is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifValue() {
            return choiceSelect == VALUE_CHOICE;
        }

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getValueString() {
            return valueString;
        }

        /** 
         * Set the extension value.
         * 
         * @param valueString
         */
        public void setValueString(String valueString) {
            setChoiceSelect(VALUE_CHOICE);
            this.valueString = valueString;
        }

        /** 
         * Get the 'UOM' attribute value. Age unit of measure.
        Example: Year
         * 
         * @return value
         */
        public AgeUnitSimpleType getValueUOM() {
            return valueUOM;
        }

        /** 
         * Set the 'UOM' attribute value. Age unit of measure.
        Example: Year
         * 
         * @param valueUOM
         */
        public void setValueUOM(AgeUnitSimpleType valueUOM) {
            setChoiceSelect(VALUE_CHOICE);
            this.valueUOM = valueUOM;
        }

        /** 
         * Check if BirthDate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifBirthDate() {
            return choiceSelect == BIRTH_DATE_CHOICE;
        }

        /** 
         * Get the 'BirthDate' element value. Traveler birth date.  Example: YYYY-MM-DD
         * 
         * @return value
         */
        public Date getBirthDate() {
            return birthDate;
        }

        /** 
         * Set the 'BirthDate' element value. Traveler birth date.  Example: YYYY-MM-DD
         * 
         * @param birthDate
         */
        public void setBirthDate(Date birthDate) {
            setChoiceSelect(BIRTH_DATE_CHOICE);
            this.birthDate = birthDate;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
