
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for DETAIL Traveler representation.

 Traveler Details, including Age/ Birthdate, Gender, FOID, FQTV information, Contact information, Spoken/ Written Languages and General Remarks.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerDetailType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TravelerSummaryType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Gender" minOccurs="0">
 *           &lt;!-- Reference to inner class Gender -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:TravelerFQTV_Type" name="FQTVs" minOccurs="0" maxOccurs="unbounded"/>
 *         &lt;xs:element type="ns:TravelerFOID_Type" name="FOIDs" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Contacts" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Languages" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelerDetailType extends TravelerSummaryType implements
    Serializable
{
    private Gender gender;
    private List<TravelerFQTVType> FQTVList = new ArrayList<TravelerFQTVType>();
    private TravelerFOIDType FOIDs;
    private Contacts contacts;
    private Languages languages;
    private Remarks remarks;

    /** 
     * Get the 'Gender' element value.
     * 
     * @return value
     */
    public Gender getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value.
     * 
     * @param gender
     */
    public void setGender(Gender gender) {
        this.gender = gender;
    }

    /** 
     * Get the list of 'FQTVs' element items. Frequent Traveler Program(s).
     * 
     * @return list
     */
    public List<TravelerFQTVType> getFQTVList() {
        return FQTVList;
    }

    /** 
     * Set the list of 'FQTVs' element items. Frequent Traveler Program(s).
     * 
     * @param list
     */
    public void setFQTVList(List<TravelerFQTVType> list) {
        FQTVList = list;
    }

    /** 
     * Get the 'FOIDs' element value. Forms of identification (FOID).
     * 
     * @return value
     */
    public TravelerFOIDType getFOIDs() {
        return FOIDs;
    }

    /** 
     * Set the 'FOIDs' element value. Forms of identification (FOID).
     * 
     * @param FOIDs
     */
    public void setFOIDs(TravelerFOIDType FOIDs) {
        this.FOIDs = FOIDs;
    }

    /** 
     * Get the 'Contacts' element value.
     * 
     * @return value
     */
    public Contacts getContacts() {
        return contacts;
    }

    /** 
     * Set the 'Contacts' element value.
     * 
     * @param contacts
     */
    public void setContacts(Contacts contacts) {
        this.contacts = contacts;
    }

    /** 
     * Get the 'Languages' element value. Spoken or Written Language(s).
     * 
     * @return value
     */
    public Languages getLanguages() {
        return languages;
    }

    /** 
     * Set the 'Languages' element value. Spoken or Written Language(s).
     * 
     * @param languages
     */
    public void setLanguages(Languages languages) {
        this.languages = languages;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }
    /** 
     * Passenger Gender
    Example: Male
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Gender" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns:TravelerGenderSimpleType">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Gender implements Serializable
    {
        private TravelerGenderSimpleType travelerGenderSimpleType;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public TravelerGenderSimpleType getTravelerGenderSimpleType() {
            return travelerGenderSimpleType;
        }

        /** 
         * Set the extension value.
         * 
         * @param travelerGenderSimpleType
         */
        public void setTravelerGenderSimpleType(
                TravelerGenderSimpleType travelerGenderSimpleType) {
            this.travelerGenderSimpleType = travelerGenderSimpleType;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
