
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Traveler FORM OF IDENTIFICATION representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerFOID_Type">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="FOID" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class FOID -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelerFOIDType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private List<FOID> FOIDList = new ArrayList<FOID>();

    /** 
     * Get the list of 'FOID' element items.
     * 
     * @return list
     */
    public List<FOID> getFOIDList() {
        return FOIDList;
    }

    /** 
     * Set the list of 'FOID' element items.
     * 
     * @param list
     */
    public void setFOIDList(List<FOID> list) {
        FOIDList = list;
    }
    /** 
     * Passenger Form of Identification detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOID" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:CodesetType" name="Type"/>
     *       &lt;xs:element type="xs:string" name="ID"/>
     *       &lt;xs:element type="xs:string" name="Issuer" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FOID implements Serializable
    {
        private CodesetType type;
        private String ID;
        private String issuer;

        /** 
         * Get the 'Type' element value. ID form. Examples: PT (passport), CC (credit card), FF (frequent flyer), DL (drivers license)

        Encoding Scheme: IATA Padis Codeset - List for data element 7365 - Processing indicator, coded
         * 
         * @return value
         */
        public CodesetType getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value. ID form. Examples: PT (passport), CC (credit card), FF (frequent flyer), DL (drivers license)

        Encoding Scheme: IATA Padis Codeset - List for data element 7365 - Processing indicator, coded
         * 
         * @param type
         */
        public void setType(CodesetType type) {
            this.type = type;
        }

        /** 
         * Get the 'ID' element value. FOID ID value. Example: NY122345
         * 
         * @return value
         */
        public String getID() {
            return ID;
        }

        /** 
         * Set the 'ID' element value. FOID ID value. Example: NY122345
         * 
         * @param ID
         */
        public void setID(String ID) {
            this.ID = ID;
        }

        /** 
         * Get the 'Issuer' element value. Owner/ Issuer of FOID. Example: United State Department Of State
         * 
         * @return value
         */
        public String getIssuer() {
            return issuer;
        }

        /** 
         * Set the 'Issuer' element value. Owner/ Issuer of FOID. Example: United State Department Of State
         * 
         * @param issuer
         */
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }
    }
}
