
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Traveler FQTV ACCOUNT definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerFQTV_Type">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:AirlineID"/>
 *         &lt;xs:element name="Account" minOccurs="0">
 *           &lt;!-- Reference to inner class Account -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="ProgramID" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelerFQTVType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private AirlineIDType airlineID;
    private Account account;
    private String programID;

    /** 
     * Get the 'AirlineID' element value. FQTV Program Sponsoring Airline.  Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @return value
     */
    public AirlineIDType getAirlineID() {
        return airlineID;
    }

    /** 
     * Set the 'AirlineID' element value. FQTV Program Sponsoring Airline.  Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @param airlineID
     */
    public void setAirlineID(AirlineIDType airlineID) {
        this.airlineID = airlineID;
    }

    /** 
     * Get the 'Account' element value.
     * 
     * @return value
     */
    public Account getAccount() {
        return account;
    }

    /** 
     * Set the 'Account' element value.
     * 
     * @param account
     */
    public void setAccount(Account account) {
        this.account = account;
    }

    /** 
     * Get the 'ProgramID' element value. The Program ID will be used to specify Frequent Flyer Program. This will be the name of the program
     * 
     * @return value
     */
    public String getProgramID() {
        return programID;
    }

    /** 
     * Set the 'ProgramID' element value. The Program ID will be used to specify Frequent Flyer Program. This will be the name of the program
     * 
     * @param programID
     */
    public void setProgramID(String programID) {
        this.programID = programID;
    }
    /** 
     * Traveler FQTV Account information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Account" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SignInID" minOccurs="0">
     *         &lt;!-- Reference to inner class SignInID -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Number">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:string">
     *               &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Account implements Serializable
    {
        private SignInID signInID;
        private String numberString;
        private String numberRefs;
        private String refs;

        /** 
         * Get the 'SignInID' element value.
         * 
         * @return value
         */
        public SignInID getSignInID() {
            return signInID;
        }

        /** 
         * Set the 'SignInID' element value.
         * 
         * @param signInID
         */
        public void setSignInID(SignInID signInID) {
            this.signInID = signInID;
        }

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getNumberString() {
            return numberString;
        }

        /** 
         * Set the extension value.
         * 
         * @param numberString
         */
        public void setNumberString(String numberString) {
            this.numberString = numberString;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getNumberRefs() {
            return numberRefs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param numberRefs
         */
        public void setNumberRefs(String numberRefs) {
            this.numberRefs = numberRefs;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Traveler FQTV program sign in (or user) ID.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SignInID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class SignInID implements Serializable
        {
            private String string;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
    }
}
