
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Trip Purpose contextual list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TripPurposeListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Business"/>
 *     &lt;xs:enumeration value="Leisure"/>
 *     &lt;xs:enumeration value="BusinessAndLeisure"/>
 *     &lt;xs:enumeration value="Other"/>
 *     &lt;xs:enumeration value="Unknown"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum TripPurposeListType implements Serializable {
    BUSINESS("Business"), LEISURE("Leisure"), BUSINESS_AND_LEISURE(
            "BusinessAndLeisure"), OTHER("Other"), UNKNOWN("Unknown");
    private final String value;

    private TripPurposeListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static TripPurposeListType convert(String value) {
        for (TripPurposeListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
