
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for a UTM Parameter Role List.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UTM_AppListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Campaign"/>
 *     &lt;xs:enumeration value="Source"/>
 *     &lt;xs:enumeration value="Medium"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum UTMAppListType implements Serializable {
    /** 
     * Campaign content group.
    Ex: utm_campaign=20percentpromocode

     */
    CAMPAIGN("Campaign"), /** 
                           * Referrer website idSource.
                          Example: utm_source=FareCompare

                           */
    SOURCE("Source"), /** 
                       * Link medium type.
                      Example: utm_medium=socialmedia

                       */
    MEDIUM("Medium"), OTHER("Other");
    private final String value;

    private UTMAppListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static UTMAppListType convert(String value) {
        for (UTMAppListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
