
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Transaction Processing Business Warning(s).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warnings">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Warning" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Warning -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Warnings implements Serializable
{
    private List<Warning> warningList = new ArrayList<Warning>();

    /** 
     * Get the list of 'Warning' element items.
     * 
     * @return list
     */
    public List<Warning> getWarningList() {
        return warningList;
    }

    /** 
     * Set the list of 'Warning' element items.
     * 
     * @param list
     */
    public void setWarningList(List<Warning> list) {
        warningList = list;
    }
    /** 
     * Business Warning(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warning" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:CodesetType" name="Type" minOccurs="0"/>
     *           &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
     *           &lt;xs:element type="ns:MultiAssociationType" name="Associations" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Warning extends KeyWithMetaObjectBaseType implements
        Serializable
    {
        private CodesetType type;
        private Remarks remarks;
        private MultiAssociationType associations;

        /** 
         * Get the 'Type' element value. 
                            Business warning type code and description. Encoding Scheme: IATA Padis Codeset - Error and Warnings
                          
         * 
         * @return value
         */
        public CodesetType getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value. 
                            Business warning type code and description. Encoding Scheme: IATA Padis Codeset - Error and Warnings
                          
         * 
         * @param type
         */
        public void setType(CodesetType type) {
            this.type = type;
        }

        /** 
         * Get the 'Remarks' element value.
         * 
         * @return value
         */
        public Remarks getRemarks() {
            return remarks;
        }

        /** 
         * Set the 'Remarks' element value.
         * 
         * @param remarks
         */
        public void setRemarks(Remarks remarks) {
            this.remarks = remarks;
        }

        /** 
         * Get the 'Associations' element value. 
                            Business Warning Association(s), including Order, Order Item, Passenger, Group, Offer Item and Service.
                          
         * 
         * @return value
         */
        public MultiAssociationType getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value. 
                            Business Warning Association(s), including Order, Order Item, Passenger, Group, Offer Item and Service.
                          
         * 
         * @param associations
         */
        public void setAssociations(MultiAssociationType associations) {
            this.associations = associations;
        }
    }
}
