
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Weight Unit of Measure list constraint. Examples: Kilogram, Pound
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WeightUnitSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Kilogram"/>
 *     &lt;xs:enumeration value="Pound"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum WeightUnitSimpleType implements Serializable {
    KILOGRAM("Kilogram"), POUND("Pound");
    private final String value;

    private WeightUnitSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static WeightUnitSimpleType convert(String value) {
        for (WeightUnitSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
