
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderList transaction set retrieves a list of Orders that match one or more search criteria.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRS" xmlns:ns1="http://xml.amadeus.com/QDQLRR_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IATA_OrderListRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:choice>
 *         &lt;xs:element type="ns:ErrorType" name="Error" maxOccurs="unbounded"/>
 *         &lt;xs:element type="ns:ResponseType" name="Response"/>
 *       &lt;/xs:choice>
 *       &lt;xs:element name="AugmentationPoint" minOccurs="0">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element ref="ns1:Queue_ListReply"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:MessageDocType" name="MessageDoc" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:IATA_PayloadStandardAttributesType" name="PayloadAttributes" minOccurs="0" maxOccurs="1"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class IATAOrderListRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int ERROR_LIST_CHOICE = 0;
    private static final int RESPONSE_CHOICE = 1;
    private List<ErrorType> errorList = new ArrayList<ErrorType>();
    private ResponseType response;
    private QueueListReply augmentationPoint;
    private MessageDocType messageDoc;
    private IATAPayloadStandardAttributesType payloadAttributes;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ErrorList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrorList() {
        return choiceSelect == ERROR_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Error' element items. Error(s) that prevented message processing.
     * 
     * @return list
     */
    public List<ErrorType> getErrorList() {
        return errorList;
    }

    /** 
     * Set the list of 'Error' element items. Error(s) that prevented message processing.
     * 
     * @param list
     */
    public void setErrorList(List<ErrorType> list) {
        setChoiceSelect(ERROR_LIST_CHOICE);
        errorList = list;
    }

    /** 
     * Check if Response is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifResponse() {
        return choiceSelect == RESPONSE_CHOICE;
    }

    /** 
     * Get the 'Response' element value. OrderList response information.
     * 
     * @return value
     */
    public ResponseType getResponse() {
        return response;
    }

    /** 
     * Set the 'Response' element value. OrderList response information.
     * 
     * @param response
     */
    public void setResponse(ResponseType response) {
        setChoiceSelect(RESPONSE_CHOICE);
        this.response = response;
    }

    /** 
     * Get the 'Queue_ListReply' element value. Implementer-Augmented Structure.
     * 
     * @return value
     */
    public QueueListReply getAugmentationPoint() {
        return augmentationPoint;
    }

    /** 
     * Set the 'Queue_ListReply' element value. Implementer-Augmented Structure.
     * 
     * @param augmentationPoint
     */
    public void setAugmentationPoint(QueueListReply augmentationPoint) {
        this.augmentationPoint = augmentationPoint;
    }

    /** 
     * Get the 'MessageDoc' element value. NDC Message document information.
     * 
     * @return value
     */
    public MessageDocType getMessageDoc() {
        return messageDoc;
    }

    /** 
     * Set the 'MessageDoc' element value. NDC Message document information.
     * 
     * @param messageDoc
     */
    public void setMessageDoc(MessageDocType messageDoc) {
        this.messageDoc = messageDoc;
    }

    /** 
     * Get the 'PayloadAttributes' element value. IATA standard payload attributes
     * 
     * @return value
     */
    public IATAPayloadStandardAttributesType getPayloadAttributes() {
        return payloadAttributes;
    }

    /** 
     * Set the 'PayloadAttributes' element value. IATA standard payload attributes
     * 
     * @param payloadAttributes
     */
    public void setPayloadAttributes(
            IATAPayloadStandardAttributesType payloadAttributes) {
        this.payloadAttributes = payloadAttributes;
    }
}
