
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs;

import java.io.Serializable;

/** 
 * A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxGroupType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:QtyType" name="IntendedPaxQty" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxGroupID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxGroupName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaxGroupType implements Serializable
{
    private QtyType intendedPaxQty;
    private String paxGroupID;
    private String paxGroupName;

    /** 
     * Get the 'IntendedPaxQty' element value. Intended number of passengers for this Group.
     * 
     * @return value
     */
    public QtyType getIntendedPaxQty() {
        return intendedPaxQty;
    }

    /** 
     * Set the 'IntendedPaxQty' element value. Intended number of passengers for this Group.
     * 
     * @param intendedPaxQty
     */
    public void setIntendedPaxQty(QtyType intendedPaxQty) {
        this.intendedPaxQty = intendedPaxQty;
    }

    /** 
     * Get the 'PaxGroupID' element value. Uniquely identifies a Passenger Group.
     * 
     * @return value
     */
    public String getPaxGroupID() {
        return paxGroupID;
    }

    /** 
     * Set the 'PaxGroupID' element value. Uniquely identifies a Passenger Group.
     * 
     * @param paxGroupID
     */
    public void setPaxGroupID(String paxGroupID) {
        this.paxGroupID = paxGroupID;
    }

    /** 
     * Get the 'PaxGroupName' element value. The name of the group.
     * 
     * @return value
     */
    public String getPaxGroupName() {
        return paxGroupName;
    }

    /** 
     * Set the 'PaxGroupName' element value. The name of the group.
     * 
     * @param paxGroupName
     */
    public void setPaxGroupName(String paxGroupName) {
        this.paxGroupName = paxGroupName;
    }
}
