
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs;

import java.io.Serializable;

/** 
 * Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to fulfillment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:IndividualType" name="Individual" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaxType implements Serializable
{
    private IndividualType individual;
    private String paxID;

    /** 
     * Get the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @return value
     */
    public IndividualType getIndividual() {
        return individual;
    }

    /** 
     * Set the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @param individual
     */
    public void setIndividual(IndividualType individual) {
        this.individual = individual;
    }

    /** 
     * Get the 'PaxID' element value. Uniquely identifies a Passenger within the context of one message.
     * 
     * @return value
     */
    public String getPaxID() {
        return paxID;
    }

    /** 
     * Set the 'PaxID' element value. Uniquely identifies a Passenger within the context of one message.
     * 
     * @param paxID
     */
    public void setPaxID(String paxID) {
        this.paxID = paxID;
    }
}
