/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.rules.GdsAccountPropertyMatcher;
import com.gridnine.xtrip.common.gds.rules.GdsPropertiesProvider;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class GdsAccountPropertyMatcherTest {
    private final GdsAccountPropertyMatcher matcher = new GdsAccountPropertyMatcher();

    @Test
    public void matchSupportsGdsPropertiesProvider() {
        EntityReference<? extends BaseGdsAccount> gdsAccount = this.createGdsAccount();
        GdsPropertiesProviderForTesting ps = new GdsPropertiesProviderForTesting();
        Assert.assertFalse((boolean)this.matcher.match((Object)ps, (RuleCondition)Conditions.EQUALS, Arrays.asList(gdsAccount)));
        Assert.assertFalse((boolean)this.matcher.match((Object)ps, (RuleCondition)Conditions.NOT_EQUALS, Arrays.asList(gdsAccount)));
    }

    protected EntityReference<? extends BaseGdsAccount> createGdsAccount() {
        EntityReference gdsAccount = new EntityReference("sabre-gds-account", SabreGdsAccount.class, null);
        return gdsAccount;
    }

    @Test
    public void matchReturnsFalseIfPropertySetIsNotGdsPropertiesProvider() {
        EntityReference<? extends BaseGdsAccount> gdsAccount = this.createGdsAccount();
        Assert.assertFalse((boolean)this.matcher.match((Object)"", (RuleCondition)Conditions.EQUALS, Arrays.asList(gdsAccount)));
        Assert.assertFalse((boolean)this.matcher.match((Object)"", (RuleCondition)Conditions.NOT_EQUALS, Arrays.asList(gdsAccount)));
    }

    private class GdsPropertiesProviderForTesting
    implements GdsPropertiesProvider {
        private GdsPropertiesProviderForTesting() {
        }

        public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
            return null;
        }

        public String getGdsName() {
            return null;
        }
    }
}

