/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.AirPriceRQParameters;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.model.CalculationLineSegmentParsingResult;
import com.gridnine.xtrip.common.parsers.model.CalculationLineSegmentTariffParsingResult;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AirItineraryPricingInfoVatAdapter
implements AirProductVatCalculator.VatProductAdapter<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo, OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes.Tax, CalculationLineSegmentTariffParsingResult, CalculationLineSegmentParsingResult> {
    private final AirPriceRQParameters parameters;
    private final Map<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes.Tax, String> TAX_UIDS = new HashMap<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes.Tax, String>();
    private int taxUid = 0;

    public AirItineraryPricingInfoVatAdapter(AirPriceRQParameters parameters) {
        this.parameters = parameters;
    }

    public List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes.Tax> getTaxes(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product, DictionaryReference<PassengerType> passengerType) {
        OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes taxes = product.getItinTotalFare().getTaxes();
        List taxList = taxes.getTaxList();
        if (taxList != null) {
            return taxList;
        }
        if (!StringUtils.isBlank((String)taxes.getTotalAmount())) {
            OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes.Tax tax = new OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes.Tax();
            tax.setTicketingTaxCode("XT");
            tax.setAmount(taxes.getTotalAmount());
            return Collections.singletonList(tax);
        }
        return Collections.emptyList();
    }

    public String getUid(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes.Tax tax) {
        String uid = this.TAX_UIDS.get(tax);
        if (uid == null) {
            uid = Integer.toString(this.taxUid++);
            this.TAX_UIDS.put(tax, uid);
        }
        return uid;
    }

    public BigDecimal getPenalty(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        return null;
    }

    public BigDecimal getEquivalentAmount(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes.Tax tax) {
        return new BigDecimal(tax.getAmount());
    }

    public ProductStatus getStatus(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        return ProductStatus.BOOKING;
    }

    public BigDecimal getEquivalentFare(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product, DictionaryReference<PassengerType> passengerType) {
        OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare itinTotalFare = product.getItinTotalFare();
        if (itinTotalFare.getEquivFare() != null) {
            return new BigDecimal(itinTotalFare.getEquivFare().getAmount());
        }
        return new BigDecimal(itinTotalFare.getBaseFare().getAmount());
    }

    public Date getIssueDate(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        return new Date();
    }

    public boolean isAddValidationMessages() {
        return false;
    }

    public String getTitle(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        return null;
    }

    public void addValidationMessage(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product, ValidationMessage validationMessage) {
    }

    public DictionaryReference<Airline> getValidatingAirline(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        return this.parameters.getCarrier();
    }

    public MCOCategory getMcoCategory(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        return null;
    }

    public ProductCategory getProductCategory(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        return ProductCategory.AIR;
    }

    public String getTaxCode(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes.Tax tax) {
        return tax.getTicketingTaxCode();
    }

    public Date getVatIssueDate(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo prod) {
        return new Date();
    }

    public List<CalculationLineSegmentTariffParsingResult> getSegmentTariffs(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        try {
            return GDSHelper.parseCalculationLine((String)product.getFareCalculation().getText()).getSegmentTariffs();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<CalculationLineSegmentParsingResult> getSegments(CalculationLineSegmentTariffParsingResult segmentTariff) {
        return segmentTariff.getSegments();
    }

    public DictionaryReference<GeoLocation> getDepartureLocation(CalculationLineSegmentParsingResult seg) {
        return SabreHelper.resolveNativeCode(GeoLocation.class, (String)seg.getDepartureCode());
    }

    public DictionaryReference<GeoLocation> getArrivalLocation(CalculationLineSegmentParsingResult seg) {
        return SabreHelper.resolveNativeCode(GeoLocation.class, (String)seg.getArrivalCode());
    }

    public EntityReference<Organization> getSupplier(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        return this.parameters.getSupplier();
    }

    public String getBlankOwnerNumber(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        return null;
    }

    public EntityReference<Organization> getBlankOwner(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        return this.parameters.getBlankOwner();
    }

    public OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo getTransportationTypeProduct(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo prod) {
        return prod;
    }

    public DictionaryReference<Airline> getMarketingAirline(CalculationLineSegmentParsingResult seg) {
        return SabreHelper.resolveNativeCode(Airline.class, (String)seg.getAirlineCode());
    }

    public String getGdsCurrency(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo prod) {
        return prod.getItinTotalFare().getTotalFare().getCurrencyCode();
    }

    public EntityReference<? extends BaseEntity> getGdsAccount(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo product) {
        return this.parameters.getGdsAccount();
    }
}

