/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre;

import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreErrorsTranslatorHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRS;
import com.sabre.services.stl.v01.ApplicationResults;
import com.sabre.services.stl.v01.SystemSpecificResults;
import com.sabre.services.stlmessagecommon.v0201.MessageCondition;
import com.sabre.services.stlpayload.v0201.ProblemInformation;
import com.sabre.webservices.pnrbuilder.v119.UpdateErrorsPNRB;
import com.sabre.webservices.pnrbuilder.v119.UpdateReservationRS;
import com.sabre.webservices.sabrexml.AddRemarkRS;
import com.sabre.webservices.sabrexml.AirTicketRS;
import com.sabre.webservices.sabrexml.BargainFinderPlusRS;
import com.sabre.webservices.sabrexml.ContextChangeRS;
import com.sabre.webservices.sabrexml.DeletePriceQuoteRS;
import com.sabre.webservices.sabrexml.DesignatePrinterRS;
import com.sabre.webservices.sabrexml.DisplayCurrencyRS;
import com.sabre.webservices.sabrexml.ETicketCouponRS;
import com.sabre.webservices.sabrexml.EndTransactionRS;
import com.sabre.webservices.sabrexml.Errors;
import com.sabre.webservices.sabrexml.IgnoreTransactionRS;
import com.sabre.webservices.sabrexml.InvoiceItineraryRS;
import com.sabre.webservices.sabrexml.OTAAirAvailRS;
import com.sabre.webservices.sabrexml.OTAAirBookRS;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import com.sabre.webservices.sabrexml.OTAAirScheduleRS;
import com.sabre.webservices.sabrexml.QueueAccessRS;
import com.sabre.webservices.sabrexml.QueuePlaceRS;
import com.sabre.webservices.sabrexml.RulesFromPriceRS;
import com.sabre.webservices.sabrexml.SabreCommandLLSRS;
import com.sabre.webservices.sabrexml.SpecialServiceRS;
import com.sabre.webservices.sabrexml.TravelItineraryDivideRS;
import com.sabre.webservices.sabrexml.VendorCodesRS;
import com.sabre.webservices.sabrexml.VerifyFlightDetailsRS;
import com.sabre.webservices.sabrexml.VoidTicketRS;
import com.sabre.webservices.triprecord.BaseTripResponse;
import com.sabre.webservices.triprecord.CarbonCalculatorRS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ApplicationResultsParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Object response = ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Boolean checkResponse = (Boolean)ctx.getObject((Enum)IBusGdsSabreContextKeys.CHECK_RESPONSE);
        if (checkResponse != null && !checkResponse.booleanValue()) {
            return;
        }
        if (response instanceof AirTicketRS) {
            ApplicationResultsParser.parseApplicationResults(((AirTicketRS)response).getApplicationResults(), ctx);
        } else if (response instanceof BargainFinderPlusRS) {
            ApplicationResultsParser.parseApplicationResults(((BargainFinderPlusRS)response).getApplicationResults(), ctx);
        } else if (response instanceof ContextChangeRS) {
            ApplicationResultsParser.parseApplicationResults(((ContextChangeRS)response).getApplicationResults(), ctx);
        } else if (response instanceof DeletePriceQuoteRS) {
            ApplicationResultsParser.parseApplicationResults(((DeletePriceQuoteRS)response).getApplicationResults(), ctx);
        } else if (response instanceof DesignatePrinterRS) {
            ApplicationResultsParser.parseApplicationResults(((DesignatePrinterRS)response).getApplicationResults(), ctx);
        } else if (response instanceof DisplayCurrencyRS) {
            ApplicationResultsParser.parseApplicationResults(((DisplayCurrencyRS)response).getApplicationResults(), ctx);
        } else if (response instanceof EndTransactionRS) {
            ApplicationResultsParser.parseApplicationResults(((EndTransactionRS)response).getApplicationResults(), ctx);
        } else if (response instanceof IgnoreTransactionRS) {
            ApplicationResultsParser.parseApplicationResults(((IgnoreTransactionRS)response).getApplicationResults(), ctx);
        } else if (response instanceof InvoiceItineraryRS) {
            ApplicationResultsParser.parseApplicationResults(((InvoiceItineraryRS)response).getApplicationResults(), ctx);
        } else if (response instanceof OTAAirAvailRS) {
            ApplicationResultsParser.parseApplicationResults(((OTAAirAvailRS)response).getApplicationResults(), ctx);
        } else if (response instanceof OTAAirBookRS) {
            ApplicationResultsParser.parseApplicationResults(((OTAAirBookRS)response).getApplicationResults(), ctx);
        } else if (response instanceof OTAAirPriceRS) {
            ApplicationResultsParser.parseApplicationResults(((OTAAirPriceRS)response).getApplicationResults(), ctx);
        } else if (response instanceof OTAAirScheduleRS) {
            ApplicationResultsParser.parseApplicationResults(((OTAAirScheduleRS)response).getApplicationResults(), ctx);
        } else if (response instanceof PassengerDetailsRS) {
            this.parseApplicationResultsV3(((PassengerDetailsRS)response).getApplicationResults(), ctx);
        } else if (response instanceof QueueAccessRS) {
            ApplicationResultsParser.parseApplicationResults(((QueueAccessRS)response).getApplicationResults(), ctx);
        } else if (response instanceof QueuePlaceRS) {
            ApplicationResultsParser.parseApplicationResults(((QueuePlaceRS)response).getApplicationResults(), ctx);
        } else if (response instanceof SpecialServiceRS) {
            ApplicationResultsParser.parseApplicationResults(((SpecialServiceRS)response).getApplicationResults(), ctx);
        } else if (response instanceof RulesFromPriceRS) {
            ApplicationResultsParser.parseApplicationResults(((RulesFromPriceRS)response).getApplicationResults(), ctx);
        } else if (response instanceof TravelItineraryDivideRS) {
            ApplicationResultsParser.parseApplicationResults(((TravelItineraryDivideRS)response).getApplicationResults(), ctx);
        } else if (response instanceof VendorCodesRS) {
            ApplicationResultsParser.parseApplicationResults(((VendorCodesRS)response).getApplicationResults(), ctx);
        } else if (response instanceof VoidTicketRS) {
            ApplicationResultsParser.parseApplicationResults(((VoidTicketRS)response).getApplicationResults(), ctx);
        } else if (response instanceof ETicketCouponRS) {
            ApplicationResultsParser.parseApplicationResults(((ETicketCouponRS)response).getApplicationResults(), ctx);
        } else if (response instanceof UpdateReservationRS) {
            ApplicationResultsParser.parseUpdateErrorsPNRB(((UpdateReservationRS)response).getErrors(), ctx);
        } else if (response instanceof AddRemarkRS) {
            ApplicationResultsParser.parseApplicationResults(((AddRemarkRS)response).getApplicationResults(), ctx);
        } else if (response instanceof VerifyFlightDetailsRS) {
            ApplicationResultsParser.parseApplicationResults(((VerifyFlightDetailsRS)response).getApplicationResults(), ctx);
        } else if (response instanceof CarbonCalculatorRS) {
            ApplicationResultsParser.parseBaseTripResponseErrors(((CarbonCalculatorRS)response).getErrors(), ctx);
        } else if (response instanceof SabreCommandLLSRS) {
            ApplicationResultsParser.parseApplicationResults(((SabreCommandLLSRS)response).getApplicationResults(), ctx);
        }
    }

    private static void parseErrors(Errors errors, MessageContext ctx) throws Exception {
        if (errors != null && errors.getErrorList() != null) {
            SabreErrorsTranslatorHelper.parseErrors(errors.getErrorList().stream().map(Errors._Error::getErrorMessage).collect(Collectors.toList()), null, ctx);
        }
    }

    private static void parseUpdateErrorsPNRB(UpdateErrorsPNRB errors, MessageContext ctx) throws Exception {
        if (errors != null && errors.getErrorList() != null) {
            SabreErrorsTranslatorHelper.parseErrors(errors.getErrorList().stream().map(UpdateErrorsPNRB._Error::getMessage).collect(Collectors.toList()), Collections.emptyList(), ctx);
        }
    }

    private static void parseBaseTripResponseErrors(BaseTripResponse.Errors errors, MessageContext ctx) throws Exception {
        if (errors != null && errors.getErrorList() != null) {
            SabreErrorsTranslatorHelper.parseErrors(errors.getErrorList().stream().map(BaseTripResponse.Errors._Error::getErrorMessage).collect(Collectors.toList()), Collections.emptyList(), ctx);
        }
    }

    public static void parseApplicationResults(ApplicationResults results, MessageContext ctx) throws Exception {
        SabreErrorsTranslatorHelper.parseErrors(ApplicationResultsParser.getMessages(results.getErrorList()), ApplicationResultsParser.getMessages(results.getWarningList()), ctx);
    }

    public static List<String> getMessages(List<com.sabre.services.stl.v01.ProblemInformation> problems) {
        ArrayList<String> result = new ArrayList<String>();
        if (problems != null) {
            for (com.sabre.services.stl.v01.ProblemInformation error : problems) {
                for (SystemSpecificResults res : error.getSystemSpecificResultList()) {
                    if (res.getMessageList() != null) {
                        for (com.sabre.services.stlheader.v120.MessageCondition msg : res.getMessageList()) {
                            result.add(msg.getString());
                        }
                    }
                    if (StringUtils.isBlank((String)res.getShortText())) continue;
                    result.add(res.getShortText());
                }
            }
        }
        return result;
    }

    private void parseApplicationResultsV3(com.sabre.services.stlpayload.v0201.ApplicationResults results, MessageContext ctx) throws Exception {
        SabreErrorsTranslatorHelper.parseErrors(ApplicationResultsParser.getMessagesV3(results.getErrorList()), ApplicationResultsParser.getMessagesV3(results.getWarningList()), ctx);
    }

    private static List<String> getMessagesV3(List<ProblemInformation> problems) {
        ArrayList<String> result = new ArrayList<String>();
        if (problems != null) {
            for (ProblemInformation error : problems) {
                for (com.sabre.services.stlpayload.v0201.SystemSpecificResults res : error.getSystemSpecificResultList()) {
                    if (res.getMessageList() != null) {
                        for (MessageCondition msg : res.getMessageList()) {
                            result.add(msg.getString());
                        }
                    }
                    if (StringUtils.isBlank((String)res.getShortText())) continue;
                    result.add(res.getShortText());
                }
            }
        }
        return result;
    }
}

