/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre;

import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LuggageDimensionUnit;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaggageParserHelper {
    private static final Pattern weightPattern = Pattern.compile("(\\d+) KILOGRAMS");
    private static final Pattern sizePattern1 = Pattern.compile("(\\d+) LINEAR CENTIMETERS");
    private static final Pattern sizePattern2 = Pattern.compile("(\\d+)CM LENGTH X (\\d+)CM WIDTH X (\\d+)CM HEIGHT");

    public static void parseKgWeight(String string, ExtendedLuggageInfo luggageInfo) {
        Matcher weightMatcher = weightPattern.matcher(string);
        if (weightMatcher.find()) {
            luggageInfo.setWeight(Integer.valueOf(weightMatcher.group(1)));
            luggageInfo.setWeightUnit((DictionaryReference)DictHelper.getKgLuggageUnit().toReference());
        }
    }

    public static void parseCmSize(String string, ExtendedLuggageInfo luggageInfo) {
        Matcher sizeMatcher = sizePattern1.matcher(string);
        if (sizeMatcher.find()) {
            luggageInfo.setDimensionsSum(Integer.valueOf(sizeMatcher.group(1)));
            luggageInfo.setDimensionUnit(LuggageDimensionUnit.CENTIMETER);
        } else {
            sizeMatcher = sizePattern2.matcher(string);
            if (sizeMatcher.matches()) {
                luggageInfo.setLength(Integer.valueOf(Integer.parseInt(sizeMatcher.group(1))));
                luggageInfo.setWidth(Integer.valueOf(Integer.parseInt(sizeMatcher.group(2))));
                luggageInfo.setHeight(Integer.valueOf(Integer.parseInt(sizeMatcher.group(3))));
                luggageInfo.setDimensionUnit(LuggageDimensionUnit.CENTIMETER);
            }
        }
    }
}

