/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import com.gridnine.xtrip.server.jibxws.WsRequest;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class CirSecurityProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        WsRequest request = (WsRequest)ctx.getMandatoryObject((Enum)IBusJibxWsContextKeys.WS_REQUEST);
        this.placeCirSecurityHeader(request, ctx);
        this.placeCirCardUidHeader(request, ctx);
        this.placeCirReadCardsHeader(request, ctx);
        request.setEndpointAddress(CirSecurityProcessor.getEndpointAddress(ctx));
    }

    private void placeCirSecurityHeader(WsRequest request, MessageContext ctx) {
        EntityReference agencyTokenRef;
        PCIDSSServerExchangeSettings settings = (PCIDSSServerExchangeSettings)ctx.getObject((Enum)IBusGdsSabreContextKeys.CIR_SETTINGS);
        String agencyToken = CirHelper.agencyToken((PCIDSSServerExchangeSettings)settings, (EntityReference)(agencyTokenRef = (EntityReference)ctx.getObject((Enum)IBusGdsSabreContextKeys.CIR_AGENCY_TOKEN_REF)));
        if (Objects.nonNull(agencyToken)) {
            request.addHttpHeader("Cookie", CirHelper.appToken2Cookie((String)agencyToken));
        }
    }

    private void placeCirReadCardsHeader(WsRequest request, MessageContext ctx) {
        Boolean readCards = (Boolean)ctx.getObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_READ_CARDS);
        if (BooleanUtil.nullAsFalse((Boolean)readCards)) {
            request.addHttpHeader("X-Read-Cards", "true");
        }
    }

    private void placeCirCardUidHeader(WsRequest request, MessageContext ctx) {
        Fop fop = (Fop)ctx.getObject((Enum)IBusMidofficeContextKeys.FOP);
        Optional.ofNullable(fop).map(Fop::getCard).map(Card::getCirUid).ifPresent(cirCardUid -> request.addHttpHeader("X-Card-Ref", cirCardUid));
    }

    private static String getEndpointAddress(MessageContext ctx) {
        PCIDSSServerExchangeSettings cirSettings = (PCIDSSServerExchangeSettings)ctx.getObject((Enum)IBusGdsSabreContextKeys.CIR_SETTINGS);
        String endPoint = (String)ctx.getObject((Enum)IBusGdsSabreContextKeys.CIR_ENDPOINT);
        if (cirSettings != null && cirSettings.isEnabled() && !StringUtils.isEmpty((String)endPoint)) {
            return CirHelper.getAddressWithEndPoint((PCIDSSServerExchangeSettings)cirSettings, (String)endPoint);
        }
        SabreSession session = (SabreSession)ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
        if (session != null) {
            return session.getEndpointUrl();
        }
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        return ((SabreGdsAccount)accountCtr.getEntity()).getAddress();
    }
}

