/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre;

import com.gridnine.sabre.bfm.AirTaxType;
import com.gridnine.sabre.bfm.BaggageInformationType;
import com.gridnine.sabre.bfm.BaggageProvisionType;
import com.gridnine.sabre.bfm.BookFlightSegmentType;
import com.gridnine.sabre.bfm.CurrencyAmountGroup;
import com.gridnine.sabre.bfm.FareType;
import com.gridnine.sabre.bfm.OBFeeType;
import com.gridnine.sabre.bfm.OriginDestinationOptionType;
import com.gridnine.sabre.bfm.PTCFareBreakdownType;
import com.gridnine.sabre.bfm.PricedItineraryType;
import com.gridnine.sabre.bfm.TicketType;
import com.gridnine.sabre.bfm.WeightUnitType;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightOBFeeInfo;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreRemarksSearchContext;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LuggageUnit;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.sabre.BaggageParserHelper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTAAirLowFareSearchRSParsingHelper {
    private static final Logger log = LoggerFactory.getLogger(OTAAirLowFareSearchRSParsingHelper.class);
    public static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    public static final DateTimeFormatter DF = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static int getTravelDuration(FlightSegment fs) {
        Integer travelDuration = GdsDictHelper.getTravelDuration((DictionaryReference)fs.getLocationBegin(), (DictionaryReference)fs.getLocationEnd(), (Date)fs.getDateBegin(), (Date)fs.getDateEnd());
        if (travelDuration == null) {
            log.error("Travel duration is null");
        }
        return travelDuration != null ? travelDuration : 0;
    }

    public static boolean isETicket(PricedItineraryType pricedItinerary) {
        if (pricedItinerary.getTicketingInfo().getTicketType() != TicketType.E_TICKET) {
            return false;
        }
        for (OriginDestinationOptionType origDestOption : pricedItinerary.getAirItinerary().getOriginDestinationOptions().getOriginDestinationOptionList()) {
            for (BookFlightSegmentType flightSegment : origDestOption.getFlightSegmentList()) {
                if (flightSegment.getTPAExtensions1().getETicket().getInd().booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public static String getAccountCode(List<PTCFareBreakdownType.FareBasisCode> fareBasisCodes) {
        for (PTCFareBreakdownType.FareBasisCode fareBasisCode : fareBasisCodes) {
            if (StringUtils.isBlank((String)fareBasisCode.getAccountCode())) continue;
            return fareBasisCode.getAccountCode();
        }
        return null;
    }

    public static FlightFare createFlightFare(PTCFareBreakdownType fareBreakDown, DictionaryReference<PassengerType> passengerType) {
        FlightFare fare = new FlightFare();
        Money baseAmount = new Money();
        baseAmount.setCurrency(fareBreakDown.getPassengerFare().getBaseFareCurrencyAmountType().getCurrencyCodeGroup().getCurrencyCode());
        baseAmount.setValue(fareBreakDown.getPassengerFare().getBaseFareCurrencyAmountType().getAmount());
        fare.setEquivalentAmount(fareBreakDown.getPassengerFare().getEquivFare() != null ? fareBreakDown.getPassengerFare().getEquivFare().getAmount() : BigDecimal.ZERO);
        fare.setBaseAmount(baseAmount);
        fare.setPassengerType(passengerType);
        return fare;
    }

    public static void processTaxes(Flight flight, PTCFareBreakdownType fareBreakDown, DictionaryReference<PassengerType> passengerType) {
        HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>();
        for (AirTaxType airTaxType : fareBreakDown.getPassengerFare().getTaxes().getTaxList()) {
            BigDecimal taxValue;
            String taxCode = airTaxType.getTaxCode();
            if (taxCode.length() > 2) {
                taxCode = taxCode.substring(0, 2);
            }
            taxValue = (taxValue = (BigDecimal)data.get(taxCode)) == null ? airTaxType.getCurrencyAmountGroup().getAmount() : taxValue.add(airTaxType.getCurrencyAmountGroup().getAmount());
            data.put(taxCode, taxValue);
        }
        for (Map.Entry entry : data.entrySet()) {
            FlightTax tax = new FlightTax();
            tax.setEquivalentAmount((BigDecimal)entry.getValue());
            tax.setCode((String)entry.getKey());
            tax.setPassengerType(passengerType);
            flight.getTaxes().add(tax);
        }
    }

    public static void processOBFees(Flight flight, PTCFareBreakdownType fareBreakDown, DictionaryReference<PassengerType> passengerType) {
        BigDecimal minFee = null;
        BigDecimal maxFee = null;
        for (OBFeeType sabreOBFee : fareBreakDown.getPassengerFare().getOBFees1().getOBFeeList()) {
            BigDecimal fee = sabreOBFee.getCurrencyAmountGroup().getAmount();
            if (minFee == null || minFee.compareTo(fee) > 0) {
                minFee = fee;
            }
            if (maxFee != null && maxFee.compareTo(fee) >= 0) continue;
            maxFee = fee;
        }
        FlightOBFeeInfo obFeeInfo = new FlightOBFeeInfo();
        obFeeInfo.setMinFee(minFee);
        obFeeInfo.setMaxFee(maxFee);
        obFeeInfo.setPassengerType(passengerType);
        flight.getObFeesInfos().add(obFeeInfo);
    }

    public static Map<Integer, MiscUtil.Pair<LuggageInfo, ExtendedLuggageInfo>> getLuggageInfos(PTCFareBreakdownType fareBreakDown) {
        return OTAAirLowFareSearchRSParsingHelper.getLuggageInfosByType(fareBreakDown, BaggageProvisionType.A);
    }

    public static Map<Integer, ExtendedLuggageInfo> getCabinLuggageInfos(PTCFareBreakdownType fareBreakDown) {
        HashMap<Integer, ExtendedLuggageInfo> result = new HashMap<Integer, ExtendedLuggageInfo>();
        OTAAirLowFareSearchRSParsingHelper.getLuggageInfosByType(fareBreakDown, BaggageProvisionType.B).forEach((k, v) -> {
            ExtendedLuggageInfo cfr_ignored_0 = (ExtendedLuggageInfo)result.put((Integer)k, (ExtendedLuggageInfo)v.getSecond());
        });
        return result;
    }

    private static Map<Integer, MiscUtil.Pair<LuggageInfo, ExtendedLuggageInfo>> getLuggageInfosByType(PTCFareBreakdownType fareBreakDown, BaggageProvisionType type) {
        HashMap<Integer, MiscUtil.Pair<LuggageInfo, ExtendedLuggageInfo>> result = new HashMap<Integer, MiscUtil.Pair<LuggageInfo, ExtendedLuggageInfo>>();
        if (fareBreakDown.getPassengerFare().getTPAExtensions1() != null && fareBreakDown.getPassengerFare().getTPAExtensions1().getBaggageInformationList() != null && fareBreakDown.getPassengerFare().getTPAExtensions1().getBaggageInformationList().getBaggageInformationList() != null) {
            for (BaggageInformationType baggageInfo : fareBreakDown.getPassengerFare().getTPAExtensions1().getBaggageInformationList().getBaggageInformationList()) {
                if (baggageInfo.getSegmentList() == null || baggageInfo.getProvisionType() != type) continue;
                LuggageInfo info = OTAAirLowFareSearchRSParsingHelper.buildLuggageInfo(baggageInfo);
                ExtendedLuggageInfo extendedInfo = OTAAirLowFareSearchRSParsingHelper.buildExtendedLuggageInfo(baggageInfo);
                for (BaggageInformationType.Segment seg : baggageInfo.getSegmentList()) {
                    result.put(seg.getId(), (MiscUtil.Pair<LuggageInfo, ExtendedLuggageInfo>)new MiscUtil.Pair((Object)info, (Object)extendedInfo));
                }
            }
        }
        return result;
    }

    private static LuggageInfo buildLuggageInfo(BaggageInformationType baggageInfo) {
        if (baggageInfo.getAllowanceList() != null && !baggageInfo.getAllowanceList().isEmpty()) {
            BaggageInformationType.Allowance allowance = (BaggageInformationType.Allowance)baggageInfo.getAllowanceList().get(0);
            if (allowance.getPieces() != null) {
                LuggageInfo info = new LuggageInfo();
                if (allowance.getPieces() == 0) {
                    info.setQuantity(null);
                    info.setUnit(null);
                    info.setNil(true);
                } else {
                    info.setQuantity(allowance.getPieces());
                    info.setUnit((DictionaryReference)DictHelper.getPcLuggageUnit().toReference());
                }
                return info;
            }
            if (allowance.getWeight() != null && allowance.getUnit() != null) {
                LuggageInfo info = new LuggageInfo();
                info.setQuantity(Integer.valueOf(allowance.getWeight().intValue()));
                info.setUnit(OTAAirLowFareSearchRSParsingHelper.convertUnit(allowance.getUnit()));
                return info;
            }
        }
        return null;
    }

    private static ExtendedLuggageInfo buildExtendedLuggageInfo(BaggageInformationType baggageInfo) {
        if (baggageInfo.getAllowanceList() != null && !baggageInfo.getAllowanceList().isEmpty()) {
            BaggageInformationType.Allowance allowance = (BaggageInformationType.Allowance)baggageInfo.getAllowanceList().get(0);
            ExtendedLuggageInfo info = new ExtendedLuggageInfo();
            info.setPieces(allowance.getPieces());
            if (allowance.getWeight() != null && allowance.getUnit() != null) {
                info.setWeight(Integer.valueOf(allowance.getWeight().shortValue()));
                info.setWeightUnit(OTAAirLowFareSearchRSParsingHelper.convertUnit(allowance.getUnit()));
            } else if (allowance.getDescription1() != null) {
                BaggageParserHelper.parseKgWeight(allowance.getDescription1(), info);
            }
            if (allowance.getDescription2() != null) {
                BaggageParserHelper.parseCmSize(allowance.getDescription2(), info);
            }
            return info;
        }
        return null;
    }

    private static DictionaryReference<LuggageUnit> convertUnit(WeightUnitType unit) {
        switch (unit) {
            case KG: {
                return DictHelper.getKgLuggageUnit().toReference();
            }
            case LBS: {
                return DictHelper.getLbLuggageUnit().toReference();
            }
        }
        throw Xeption.forDeveloper((String)"unexpected unit {0}", (Object[])new Object[]{unit.name()});
    }

    public static FareInfo createFareInfo(String passengerTypeCode, DictionaryReference<PassengerType> passengerType, String segGdsId, int legIdx, int segInLegIdx, MiscUtil.Pair<LuggageInfo, ExtendedLuggageInfo> luggageInfo, ExtendedLuggageInfo cabinLuggageInfo, PTCFareBreakdownType.FareBasisCode fareBasisCode, FareType.TPAExtensions.FareComponents fareComponents) throws Exception {
        FareInfo fareInfo = new FareInfo();
        fareInfo.setPassengerType(passengerType);
        fareInfo.setFareBasis(fareBasisCode.getString());
        SabreRemarksSearchContext ctx = new SabreRemarksSearchContext();
        ctx.setPType(passengerTypeCode);
        ctx.setSegNumber(segGdsId);
        fareInfo.setRemarksSearchContext(XSUtil.toString((XSSerializable)ctx));
        if (luggageInfo != null) {
            fareInfo.setLuggageInfo((LuggageInfo)luggageInfo.getFirst());
            fareInfo.setExtendedLuggageInfo((ExtendedLuggageInfo)luggageInfo.getSecond());
        }
        FareDetails fareDetails = new FareDetails();
        if (cabinLuggageInfo != null) {
            fareDetails.setCabinLuggageInfo(cabinLuggageInfo);
        }
        if (fareComponents != null) {
            FareType.TPAExtensions.FareComponents.FareComponent fareComponent = fareComponents.getFareComponentList().stream().filter(fc -> fc.getSegmentList().stream().anyMatch(s -> s.getLegIndex() == legIdx + 1 && s.getFlightIndex() == segInLegIdx + 1)).findAny().orElseThrow(() -> Xeption.forDeveloper((String)"fare component not found for legIdx={0}, segInLegIdx={1}", (Object[])new Object[]{legIdx, segInLegIdx}));
            FarePricingParameters pricingParameters = new FarePricingParameters();
            pricingParameters.setBrandId(fareComponent.getBrandID());
            fareDetails.setPricingParameters(pricingParameters);
            L10nStringHelper.setValue((L10nString)fareDetails.getBrandName(), (String)fareComponent.getBrandName(), (Locale)Locale.ROOT);
        }
        fareInfo.setFareDetails(fareDetails);
        return fareInfo;
    }

    public static PenaltiesInfo parsePenaltiesInfo(PTCFareBreakdownType fareBreakDown) {
        PenaltiesInfo penaltiesInfo = new PenaltiesInfo();
        if (fareBreakDown.getPassengerFare().getPenaltiesInfo() != null) {
            block12: for (FareType.PenaltiesInfo.Penalty penalty : fareBreakDown.getPassengerFare().getPenaltiesInfo().getPenaltyList()) {
                switch (penalty.getType()) {
                    case REFUND: {
                        switch (penalty.getApplicability()) {
                            case BEFORE: {
                                OTAAirLowFareSearchRSParsingHelper.processPenalty(penalty, FareType.PenaltiesInfo.Penalty::getRefundable, arg_0 -> ((PenaltiesInfo)penaltiesInfo).setRefundableBeforeDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setRefundBeforeDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setCat16RefundableBefore(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setConditionsApplyRefundableBefore(arg_0));
                                continue block12;
                            }
                            case AFTER: {
                                OTAAirLowFareSearchRSParsingHelper.processPenalty(penalty, FareType.PenaltiesInfo.Penalty::getRefundable, arg_0 -> ((PenaltiesInfo)penaltiesInfo).setRefundableAfterDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setRefundAfterDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setCat16RefundableAfter(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setConditionsApplyRefundableAfter(arg_0));
                                continue block12;
                            }
                        }
                        throw Xeption.forDeveloper((String)"unsupported applicability {0}", (Object[])new Object[]{penalty.getApplicability()});
                    }
                    case EXCHANGE: {
                        switch (penalty.getApplicability()) {
                            case BEFORE: {
                                OTAAirLowFareSearchRSParsingHelper.processPenalty(penalty, FareType.PenaltiesInfo.Penalty::getChangeable, arg_0 -> ((PenaltiesInfo)penaltiesInfo).setExchangableBeforeDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setExchangeBeforeDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setCat16ExchangableBefore(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setConditionsApplyExchangableBefore(arg_0));
                                continue block12;
                            }
                            case AFTER: {
                                OTAAirLowFareSearchRSParsingHelper.processPenalty(penalty, FareType.PenaltiesInfo.Penalty::getChangeable, arg_0 -> ((PenaltiesInfo)penaltiesInfo).setExchangableAfterDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setExchangeAfterDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setCat16ExchangableAfter(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setConditionsApplyExchangableAfter(arg_0));
                                continue block12;
                            }
                        }
                        throw Xeption.forDeveloper((String)"unsupported applicability {0}", (Object[])new Object[]{penalty.getApplicability()});
                    }
                }
                throw Xeption.forDeveloper((String)"unsupported penalty type {0}", (Object[])new Object[]{penalty.getType()});
            }
        }
        return penaltiesInfo;
    }

    private static void processPenalty(FareType.PenaltiesInfo.Penalty penalty, Function<FareType.PenaltiesInfo.Penalty, Boolean> possibleGetter, Consumer<Boolean> possibleSetter, Consumer<Money> moneySetter, Consumer<Boolean> cat16Setter, Consumer<Boolean> conditionsApplySetter) {
        if (Boolean.FALSE.equals(possibleGetter.apply(penalty))) {
            possibleSetter.accept(Boolean.FALSE);
        } else {
            possibleSetter.accept(Boolean.TRUE);
            CurrencyAmountGroup currencyAmount = penalty.getCurrencyAmountGroup();
            if (currencyAmount != null) {
                moneySetter.accept(MoneyHelper.buildMoney((BigDecimal)currencyAmount.getAmount(), (String)currencyAmount.getCurrencyCodeGroup().getCurrencyCode()));
            }
        }
        cat16Setter.accept(penalty.getCat16Info());
        conditionsApplySetter.accept(Boolean.TRUE.equals(penalty.getConditionsApply()));
    }

    public static LocalDate parseLocalDate(String date) {
        return LocalDate.parse(date, DTF);
    }
}

