/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.OrganizationAirlineBonusCardsParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.specialTariff.SpecialTariffHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SabreEndorsementBuilder {
    private GDSParameters gdsParameters;
    private EntityReference<SpecialTariff> specialTariffRef;
    private Traveller traveller;
    private String vatInfo;
    private OrganizationAirlineBonusCardsParameters organizationAirlineBonusCardsParameters;
    private Customer customer;
    private EntityReference<Person> agentRef;
    private SalesChain salesChain;

    public void fill(GDSParameters gdsParameters, Flight flight, DictionaryReference<PassengerType> passengerType, SalesContext salesContext, Traveller traveller, Customer customer) {
        this.gdsParameters = gdsParameters;
        this.specialTariffRef = flight.getSpecialTariff();
        this.traveller = traveller;
        this.vatInfo = SabreServerHelper.buildEndorsementVatInfo(flight, (DictionaryReference<PassengerType>)SabreHelper.autocorrectPassengerType(passengerType, (Flight)flight));
        this.organizationAirlineBonusCardsParameters = flight.getOrganizationAirlineBonusCardsParameters();
        this.customer = customer;
        this.agentRef = salesContext.getAgent();
        this.salesChain = flight.getSalesChain();
    }

    public void fill(GDSParameters gdsParameters, Product product) {
        this.gdsParameters = gdsParameters;
        this.specialTariffRef = product.getReservation().getSpecialTariff();
        this.traveller = product.getTraveller();
        this.vatInfo = SabreServerHelper.buildEndorsementVatInfo(product);
        this.organizationAirlineBonusCardsParameters = product.getOrganizationAirlineBonusCardsParameters();
        this.customer = product.getReservation().getBookingFile().getCustomer();
        this.agentRef = product.getCashier();
        this.salesChain = AirProductHelper.getSalesChain((Product)product);
    }

    protected List<String> getParts() throws Exception {
        AirlineBonusCard card;
        String stEndorsement;
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.vatInfo);
        if (this.specialTariffRef != null && this.traveller != null && !StringUtils.isBlank((String)(stEndorsement = ((SpecialTariff)EntityStorage.get().resolve(this.specialTariffRef).getEntity()).getEndorsement()))) {
            parts.add(SpecialTariffHelper.buildEndorsement((String)stEndorsement, (Traveller)this.traveller));
        }
        parts.add(this.gdsParameters.getEndorsement());
        if (this.customer != null && this.organizationAirlineBonusCardsParameters != null && this.organizationAirlineBonusCardsParameters.getEndorsementFormat() != null && (card = GDSHelper.getOrganizationAirlineBonusCard((Customer)this.customer, this.agentRef, (SalesChain)this.salesChain, (DictionaryReference)this.organizationAirlineBonusCardsParameters.getAirline())) != null) {
            String part = this.organizationAirlineBonusCardsParameters.getEndorsementFormat();
            part = part.replaceAll("#", card.getNumber());
            parts.add(part);
        }
        return parts;
    }

    public String build() throws Exception {
        List<String> parts = this.getParts();
        if (parts.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String endorsement : parts) {
            if (StringUtils.isBlank((String)endorsement)) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(endorsement);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }
}

