/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre;

import com.gridnine.xtrip.common.gds.exceptions.MealIsNotAvailableException;
import com.gridnine.xtrip.common.gds.exceptions.PnrNotFoundException;
import com.gridnine.xtrip.common.gds.exceptions.SeatsNotConfirmedException;
import com.gridnine.xtrip.common.gds.l10n.Messages;
import com.gridnine.xtrip.common.gds.sabre.core.exceptions.PreviousEntryActivePleaseWaitForResponseException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.AuthCarrierInvldException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.AuthCarrierInvldReferToBspTableException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.CityNotAuthException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.DirectConnectMessageReceivedException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.FormatFareBasisNotAvailableException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.ItineraryChangedException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.ItineraryRequiredToCompleteTransactionException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.NeedFormOfPaymentException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.NoCombinableFaresForClassUsedException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.NoFareForClassUsedException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.NoMoreException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.NoPnrInAaaException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.NotAllowedThisCityException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.NumberOfSeatsDoesNotEqualNumberOfPartiesInSegmentException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.PacToVerifyCorrectNbrOfAcctgLinesThenEtToContinueException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.PnrHasBeenUpdatedIgnAndRetryException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.QueueSelectedWasEmptyException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.RepriceNoCorporateNegotiatedFaresExistException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.SchedulesNotYetAvailableForThisCarrierDateException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.SimultaneousChangesToPnrException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.WarningPnrModificationInProgress;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.exception.DepartureOrArrivalAirportDoesNotExistException;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;

public class SabreErrorsTranslatorHelper {
    private static final Map<Pattern, Class<? extends Xeption>> CUSTOM_EXCEPTIONS = new HashMap<Pattern, Class<? extends Xeption>>();
    private static final HashSet<Pattern> WARNINGS_TO_ERRORS;
    private static final Map<Pattern, L10nMessage> ERROR_MESSAGE_TRANSLATIONS;

    public static void parseErrors(Collection<String> errorMessages, Collection<String> warningMessages, MessageContext ctx) throws Exception {
        if (!errorMessages.isEmpty()) {
            for (String msg : errorMessages) {
                SabreErrorsTranslatorHelper.parseError(msg, ctx);
            }
            if (!warningMessages.isEmpty()) {
                for (String msg : warningMessages) {
                    for (Pattern pattern : WARNINGS_TO_ERRORS) {
                        if (!pattern.matcher(errorMessages.iterator().next()).matches()) continue;
                        SabreErrorsTranslatorHelper.parseError(msg, ctx);
                    }
                }
            }
            throw Xeption.forDeveloper((String)TextUtil.join((String)"\n", errorMessages), (Object[])new Object[0]);
        }
    }

    public static void parseError(String message, MessageContext ctx) throws Exception {
        for (Map.Entry<Pattern, Class<? extends Xeption>> entry : CUSTOM_EXCEPTIONS.entrySet()) {
            if (!entry.getKey().matcher(message).matches()) continue;
            try {
                throw entry.getValue().getConstructor(Map.class).newInstance(ctx.getRawData());
            }
            catch (NoSuchMethodException ex) {
                throw entry.getValue().newInstance();
            }
        }
        for (Map.Entry<Pattern, Class<? extends Xeption>> entry : ERROR_MESSAGE_TRANSLATIONS.entrySet()) {
            if (!entry.getKey().matcher(message).matches()) continue;
            throw new Xeption((L10nMessage)entry.getValue(), null, message, null);
        }
    }

    static {
        CUSTOM_EXCEPTIONS.put(Pattern.compile(Pattern.quote("DIRECT CONNECT MESSAGES RECEIVED - ENTER *A OR *IM")), DirectConnectMessageReceivedException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*AUTH CARRIER INVLD-0166.*", 32), AuthCarrierInvldException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*AUTH CARRIER INVLD - REFER TO BSP TABLE...W/BSP.{2}\\*-0166.*", 32), AuthCarrierInvldReferToBspTableException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(Pattern.quote("NO MORE")), NoMoreException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile("(.* )?SIMULTANEOUS CHANGES TO PNR - USE IR TO IGNORE AND RETRIEVE PNR"), SimultaneousChangesToPnrException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*\\* SIMULTANEOUS CHANGES TO PNR-USE IR TO IGNORE AND RETRIEVE PNR"), SimultaneousChangesToPnrException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*PNR HAS BEEN UPDATED ?\\- ?IGN AND RETRY.*"), PnrHasBeenUpdatedIgnAndRetryException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(Pattern.quote("QUEUE SELECTED WAS EMPTY")), QueueSelectedWasEmptyException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*NO COMBINABLE FARES FOR CLASS USED.*", 32), NoCombinableFaresForClassUsedException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*NO FARE FOR CLASS USED.*", 32), NoFareForClassUsedException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(Pattern.quote("CITY NOT AUTH")), CityNotAuthException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*NOT ALLOWED THIS CITY.*", 32), NotAllowedThisCityException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(Pattern.quote("* WARNING - PNR MODIFICATION IN PROGRESS")), WarningPnrModificationInProgress.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile("UNABLE [0-9]{2} AVAILABLE"), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*INVALID ENTRY - REENTER WITH WETR\\*T.*"), PnrNotFoundException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile("FORMAT FARE BASIS NOT AVAILABLE.*", 32), FormatFareBasisNotAvailableException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(Pattern.quote("*PAC TO VERIFY CORRECT NBR OF ACCTG LINES - THEN ET TO CONTINUE")), PacToVerifyCorrectNbrOfAcctgLinesThenEtToContinueException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(Pattern.quote("REPRICE - NO CORPORATE NEGOTIATED FARES EXIST")), RepriceNoCorporateNegotiatedFaresExistException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(Pattern.quote("ITINERARY REQUIRED TO COMPLETE TRANSACTION")), ItineraryRequiredToCompleteTransactionException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(Pattern.quote("NEED FORM OF PAYMENT-0174")), NeedFormOfPaymentException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*SCHEDULES NOT YET AVAILABLE FOR THIS CARRIER\\/DATE.*"), SchedulesNotYetAvailableForThisCarrierDateException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*No PNR in AAA.*"), NoPnrInAaaException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*ITIN CHANGED - REDISPLAY ITINERARY.*"), ItineraryChangedException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*PREVIOUS ENTRY ACTIVE\\-PLEASE WAIT FOR RESPONSE.*", 32), PreviousEntryActivePleaseWaitForResponseException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(".*NO MEAL SERVICE ON THIS FLIGHT.*"), MealIsNotAvailableException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile("NUMBER OF SEATS DOES NOT EQUAL NUMBER IN PARTY FOR *SEGMENT.*"), NumberOfSeatsDoesNotEqualNumberOfPartiesInSegmentException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile("Departure or Arrival Airport does not exist"), DepartureOrArrivalAirportDoesNotExistException.class);
        WARNINGS_TO_ERRORS = new HashSet();
        WARNINGS_TO_ERRORS.add(Pattern.compile(".*Unable to end the transaction.*", 32));
        ERROR_MESSAGE_TRANSLATIONS = new HashMap<Pattern, L10nMessage>();
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("COMM_ERR_TIMEOUT")), L10nResourcesManager.createL10nMessage((String)"TIMEOUT_ON_THE_SIDE_OF_GDS", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*RA8S.*", 32), L10nResourcesManager.createL10nMessage((String)"GDS_ASKS_REPEAT_REQUEST_AFTER_8_SECONDS", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*NAME DOES NOT MATCH FREQUENT TRAVELER NUMBER OWNER.*", 32), L10nResourcesManager.createL10nMessage((String)"NAME_DOES_NOT_MATCH_FREQUENT_TRAVELER_NUMBER_OWNER", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*FREQUENT TRAVELER NUMBER DOES NOT EXIST FOR THIS AIRLINE.*", 32), L10nResourcesManager.createL10nMessage((String)"FREQUENT_TRAVELER_NUMBER_DOES_NOT_EXIST_FOR_THIS_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("NEED VAL CARRIER-0166")), L10nResourcesManager.createL10nMessage((String)"MISSING_AIRLINE_CODE_IT_IS_NECESSARY_TO_ATTACH_THE_MASK_TO_THE_GDS", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote(".SSR FOID EXISTS FOR AT LEAST ONE PASSENGER REQUESTED")), L10nResourcesManager.createL10nMessage((String)"IT_IS_NECESSARY_TO_REMOVE_FROM_BOOKING_FOID_ELEMENT", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("EACH PASSENGER MUST HAVE SSR FOID-0052")), L10nResourcesManager.createL10nMessage((String)"EACH_PASSENGER_MUST_HAVE_SSR_FOID", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*NO REPLY FROM SERVER.*"), L10nResourcesManager.createL10nMessage((String)"NO_REPLY_FROM_SERVER", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*TOO MANY FORMS OF PAYMENT-0061.*", 32), L10nResourcesManager.createL10nMessage((String)"TOO_MANY_FORMS_OF_PAYMENT", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("UNABLE TO MODIFY/TICKET-PQ/PQR FLAGGED ITIN CHG-0133")), L10nResourcesManager.createL10nMessage((String)"AMENDED_VIOLATED_CALCULATION_MASK", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("WORLD ?FARE AT PEAK USE.*", 32), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("Sending request to the Host failed")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("AIRLINE SYSTEM UNABLE TO PROCESS TRANSACTION AT THIS TIME")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE_SEND_REQUEST_TO_THE_CALL_CENTER", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("CARRIER NOT RESPONDING-RETRY LATER")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE_REPEAT_QUERY_OR_CONTACT_THE_CALL_CENTER", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("Service provider invocation timed out")), L10nResourcesManager.createL10nMessage((String)Messages.DISCONNECTING_THE_BOOKING_SYSTEM, (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("MIN CONNX TIME SEG [0-9]{2} AT [A-Z]{3} [0-9\\.]+"), L10nResourcesManager.createL10nMessage((String)"TICKET_CAN_NOT_BE_ISSUED_DUE_TO_VIOLATIONS_MIN_CONNECTION_TIME_BETWEEN_FLIGHTS", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("AVAILABILITY SERVICE RETURNED NO BOOKING CODES")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("SYSTEM AT PEAK USE \\- RETRY IN 5 SECS \\- .*", 32), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("COMM_ERR_RAGS")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("AUTH TAT CARRIER INVALID-0166")), L10nResourcesManager.createL10nMessage((String)"INCORRECTLY_SET_THE_PRINTER_FOR_THE_TYPE_OF_BLANK_HOLDER", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("COMM_ERR_HOST_NOT_AVAIL")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*MAX NBR COMBINATIONS EXCEEDED/USE SEGMENT SELECT.*", 32), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("NO REPLY FROM SERVER\n.")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("MISSING OR INVALID AIRPORT CHECK-IN IDENTIFICATION - FOID")), L10nResourcesManager.createL10nMessage((String)"MISSING_OR_INVALID_AIRPORT_CHECK_IN_IDENTIFICATION_FOID", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("Unable to Find AAA")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("TICKETING IN PROGRESS")), L10nResourcesManager.createL10nMessage((String)"AN_ERROR_OCCURRED_DURING_QUERY_EXECUTION_CONTACT_THE_CALL_CENTER", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("UNABLE TO VERIFY MCT FOR SEG [0-9]{2} AT [A-Z]{3}"), L10nResourcesManager.createL10nMessage((String)"DISTURBED_MINIMUM_CONNECTING_TIME_BETWEEN_FLIGHTS", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*Error occurred while invoking service DssClientServiceRQ\\:1\\.0\\.0.*", 32), L10nResourcesManager.createL10nMessage((String)"THE_AIRLINE_DOES_NOT_CONFIRM_SEATS_ON_THE_SELECTED_TARIFF", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("SYSTEM UNABLE TO PROCESS")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("NEED COMMISSION PERCENT.*", 32), L10nResourcesManager.createL10nMessage((String)"FOR_BOOKED_CARRIAGE_INVALID_COMMISSION", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("UNKNOWN ERROR DURING PRICING")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("Unexpected request processing error")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("PROCESSING ERROR DETECTED - L1004")), L10nResourcesManager.createL10nMessage((String)"AN_ERROR_OCCURRED_DURING_QUERY_EXECUTION_CONTACT_THE_CALL_CENTER", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("FLIGHT NOOP FOR THIS FLIGHT/DATE")), L10nResourcesManager.createL10nMessage((String)"ON_THE_DATE_OF_THE_REQUESTED_FLIGHT_MISSING", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("UNKNOWN EXCEPTION")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("UNABLE TO PROCESS - CORRECT/RETRY - 911")), L10nResourcesManager.createL10nMessage((String)"FAILURE_IN_CONNECTION_WITH_AIRLINE_SEND_REQUEST_TO_THE_CALL_CENTER", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("CONNX SEG [0-9]{2} AT [A-Z]{3} NOT ALLOWED"), L10nResourcesManager.createL10nMessage((String)"DISTURBED_MINIMUM_CONNECTING_TIME_BETWEEN_FLIGHTS", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*PROCESSING ERROR DETECTED-0000.*", 32), L10nResourcesManager.createL10nMessage((String)"DISCONNECTION_AIRLINE", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("PREVIOUS ENTRY IN PROGRESS, PLEASE WAIT")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTING_THE_BOOKING_SYSTEM_IF_YOU_TRIED_TO_ISSUE_OR_CANCEL_TICKET", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("SCHEDULE SERVICE RETURNED NO SCHEDULES")), L10nResourcesManager.createL10nMessage((String)"FAILURE_PRICING", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*No response from service provider in time : 60000 millis.*"), L10nResourcesManager.createL10nMessage((String)"SUPPLIER_RESPONSE_TIMEOUT_NEED_NEW_REQUEST", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("Unable to connect to ICE security system.*", 32), L10nResourcesManager.createL10nMessage((String)"SUPPLIER_RESPONSE_TIMEOUT_NEED_NEW_REQUEST", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("PSS MOM messaging error")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTING_THE_BOOKING_SYSTEM_RETRY_IN_SEVERAL_MINUTES", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("AUTH-INTERNAL SYSTEM PROCESSING ERROR-CALL HELP DESK")), L10nResourcesManager.createL10nMessage((String)Messages.DISCONNECTING_THE_BOOKING_SYSTEM, (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("Connection is closed")), L10nResourcesManager.createL10nMessage((String)"DISCONNECTING_THE_BOOKING_SYSTEM_RETRY_IN_SEVERAL_MINUTES", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*RPT-0538.*", 32), L10nResourcesManager.createL10nMessage((String)"TICKETING_IMPOSSIBLE_FLIGHT_CANCELLED", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*SYSTEM UNAVAILABLE.*", 32), L10nResourcesManager.createL10nMessage((String)Messages.DISCONNECTING_THE_BOOKING_SYSTEM, (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*PROCESSING ERROR DETECTED\\-[0-9]{4}.*", 32), L10nResourcesManager.createL10nMessage((String)Messages.DISCONNECTING_THE_BOOKING_SYSTEM, (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("Unable to load MDR SDSPRCRSVALCXR01")), L10nResourcesManager.createL10nMessage((String)Messages.DISCONNECTING_THE_BOOKING_SYSTEM, (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("VENDOR PROCESSING ERROR.*"), L10nResourcesManager.createL10nMessage((String)Messages.DISCONNECTING_THE_BOOKING_SYSTEM, (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("\\.PASSENGER TYPE FUNCTION INACTIVE IN TJR"), L10nResourcesManager.createL10nMessage((String)"\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b PASSENGER TYPE \u0432 PCC Sabre . \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0442\u0435\u0445.\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0443 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043b\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u0430", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("\\.ITEM TOO LONG\\.NOT ENT BGNG WITH"), L10nResourcesManager.createL10nMessage((String)"ITEM_TOO_LONG", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("UNABLE TO TICKET \\- EXCEEDS MAXIMUM ALLOWED VALIDATED ON [A-Z0-9]{2}-1618"), L10nResourcesManager.createL10nMessage((String)"\u0418\u0441\u0447\u0435\u0440\u043f\u0430\u043d \u0441\u0442\u043e\u043a \u0431\u043b\u0430\u043d\u043a\u043e\u0432 \u0434\u043b\u044f \u043e\u0444\u0438\u0441\u0430. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0437\u0430 \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435\u043c \u0432 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044e", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*UNABLE TO ACCEPT FQTV NUMBERS FOR [A-Z0-9]{2} \\- CALL DIRECT.*", 32), L10nResourcesManager.createL10nMessage((String)"\u041f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a \u043d\u0435 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u0442 \u043a\u0430\u0440\u0442\u044b \u0447\u0430\u0441\u0442\u043e \u043b\u0435\u0442\u0430\u044e\u0449\u0438\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u0447\u0435\u0440\u0435\u0437 online . \u0414\u043b\u044f \u0432\u043d\u0435\u0441\u0435\u043d\u0438\u044f \u043a\u0430\u0440\u0442\u044b \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u0430/\u043a", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*SYSTEM HOUSKPING.*", 32), L10nResourcesManager.createL10nMessage((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0415\u0441\u043b\u0438 \u0412\u044b \u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u0438\u043b\u0435\u0442 \u0438\u043b\u0438 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437, \u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".SSR NOT VALID FOR THIS AIRLINE.*"), L10nResourcesManager.createL10nMessage((String)"\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f \u043d\u0435 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u0442 \u0440\u0435\u043c\u0430\u0440\u043a\u0443 SSR \u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("MAXIMUM TICKET/DOCUMENT LIMIT REACHED IN AIRLINE SYSTEM"), L10nResourcesManager.createL10nMessage((String)"\u0418\u0441\u0447\u0435\u0440\u043f\u0430\u043d \u043b\u0438\u043c\u0438\u0442 \u0434\u043b\u044f \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u0442\u043e\u043a\u0430. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u0430/\u043a \u0437\u0430 \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435\u043c", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("CREDIT CARD AUTH DECLINED - CALL CREDIT CARD COMPANY")), L10nResourcesManager.createL10nMessage((String)"\u0424\u043e\u0440\u043c\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0430 \u0430/\u043a. \u0417\u0430 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435\u043c \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(Pattern.quote("OFF QUEUE - QNFM NOW IN PROGRESS")), L10nResourcesManager.createL10nMessage((String)"\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 \u0432 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0440\u043e\u0441", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile("NOT VALID FOR CARRIER [A-Z0-9]{2}.*"), L10nResourcesManager.createL10nMessage((String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*BRANDING SERVICE IS UNAVAILABLE.*", 32), L10nResourcesManager.createL10nMessage((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0435\u0439. \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0440\u043e\u0441 \u0447\u0435\u0440\u0435\u0437 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043c\u0438\u043d\u0443\u0442 \u0438\u043b\u0438 \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*B21\\- PROCESSING ERROR \\- TRY AGAIN.*", 32), L10nResourcesManager.createL10nMessage((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0415\u0441\u043b\u0438 \u0412\u044b \u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u0438\u043b\u0435\u0442 \u0438\u043b\u0438 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437, \u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*INVALID BRANDING SERVICE RESPONSE.*", 32), L10nResourcesManager.createL10nMessage((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0430/\u043a . \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0440\u043e\u0441 \u0447\u0435\u0440\u0435\u0437 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043c\u0438\u043d\u0443\u0442", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*PROCESSING ERROR DETECTED.*", 32), L10nResourcesManager.createL10nMessage((String)"\u041f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u0414\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0437\u0430\u043a\u0430\u0437\u0430 \u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0432\u044f\u0437\u0430\u0442\u044c\u0441\u044f \u0441 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440\u043e\u043c", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*UNABLE TO PROCESS \\- SYSTEM ERROR.*", 32), L10nResourcesManager.createL10nMessage((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0415\u0441\u043b\u0438 \u0412\u044b \u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u0438\u043b\u0435\u0442 \u0438\u043b\u0438 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437, \u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*HOST UNAVAILABLE.*", 32), L10nResourcesManager.createL10nMessage((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0415\u0441\u043b\u0438 \u0412\u044b \u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u0438\u043b\u0435\u0442 \u0438\u043b\u0438 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437, \u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*INVALID ENTRY.*", 32), L10nResourcesManager.createL10nMessage((String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0440\u0443\u0447\u043d\u043e\u0433\u043e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f, \u0434\u0430\u043b\u044c\u043d\u0435\u0439\u0448\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0441 \u0437\u0430\u043a\u0430\u0437\u043e\u043c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u0432 \u0441\u043b\u0443\u0436\u0431\u0443 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438", (Object[])new Object[0]));
        ERROR_MESSAGE_TRANSLATIONS.put(Pattern.compile(".*INVALID EMAIL CHARACTERS.*", 32), L10nResourcesManager.createL10nMessage((String)"INVALID_EMAIL_CHARACTERS", (Object[])new Object[0]));
    }
}

