/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.MaskSensitiveTraceDataHelper;
import com.gridnine.sabre.jaxws.messageheader.From;
import com.gridnine.sabre.jaxws.messageheader.MessageData;
import com.gridnine.sabre.jaxws.messageheader.MessageHeader;
import com.gridnine.sabre.jaxws.messageheader.PartyId;
import com.gridnine.sabre.jaxws.messageheader.Service;
import com.gridnine.sabre.jaxws.messageheader.To;
import com.gridnine.sabre.jaxws.secext.Security;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jaxws.IBusWsContextKeys;
import com.gridnine.xtrip.server.jaxws.WsRequest;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SabreJaxWsRequestBuilder
extends BaseProcessor {
    private static final String MESSAGE_HEADER_VERSION = "2.0";
    private static final String PARTY_ID_TYPE = "urn:x12.org:IO5:01";
    private static final String PARTY_ID_FROM = "gridnine.com";
    private static final String PARTY_ID_TO = "webservices.sabre.com";
    private static final String SERVICE_TYPE = "sabreXML";
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");
    private static final String USERNAME_TOKEN_DOMAIN = "DEFAULT";

    public void process(MessageContext ctx) throws Exception {
        WsRequest request = new WsRequest();
        request.getHeaders().add(this.createMessageHeader(ctx));
        request.getHeaders().add(this.createSecurityHeader(ctx));
        request.setPayload(ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD));
        request.setEndpointAddress(SabreJaxWsRequestBuilder.getEndpointAddress(ctx));
        Class serviceClass = (Class)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.SABRE_WS_SERVICE_CLASS);
        request.setServiceClass(serviceClass);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.SABRE_WS_SERVICE_CLASS, null);
        request.setWsdlLocationDir("wsdl");
        ctx.putObject((Enum)IBusWsContextKeys.WS_REQUEST, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, null);
    }

    private MessageHeader createMessageHeader(MessageContext ctx) {
        String ipcc;
        String conversationId;
        SabreSession session = (SabreSession)ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
        String actionCode = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, null);
        if (session != null) {
            conversationId = session.getConversationId();
            ipcc = session.getIpcc();
            session.setLastModified(new Date());
        } else {
            conversationId = String.format("%s@%s", UUID.randomUUID(), PARTY_ID_FROM);
            EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
            ipcc = ((SabreGdsAccount)accountCtr.getEntity()).getPrimaryPCC();
        }
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.setVersion(MESSAGE_HEADER_VERSION);
        messageHeader.setConversationId(conversationId);
        From from = new From();
        PartyId partyId = new PartyId();
        partyId.setType(PARTY_ID_TYPE);
        partyId.setValue(PARTY_ID_FROM);
        from.getPartyId().add(partyId);
        messageHeader.setFrom(from);
        To to = new To();
        PartyId toPartyId = new PartyId();
        toPartyId.setType(PARTY_ID_TYPE);
        toPartyId.setValue(PARTY_ID_TO);
        to.getPartyId().add(toPartyId);
        messageHeader.setTo(to);
        messageHeader.setCPAId(ipcc);
        Service service = new Service();
        service.setType(SERVICE_TYPE);
        if (!"PassengerDetailsRQ".equals(actionCode)) {
            service.setValue(actionCode);
        } else {
            service.setValue("");
        }
        messageHeader.setService(service);
        messageHeader.setAction(actionCode);
        long timestamp = MiscUtil.getTimestamp();
        String mid = String.format("mid:%s@%s", UUID.randomUUID(), PARTY_ID_FROM);
        MessageData messageData = new MessageData();
        messageData.setMessageId(mid);
        messageData.setTimestamp(String.format("%sZ", TIMESTAMP_FORMATTER.print(timestamp)));
        messageHeader.setMessageData(messageData);
        this.log.debug(String.format("conversationId=%s, actionCode=%s, mid=%s, tid=%s", conversationId, actionCode, mid, Thread.currentThread().getId()));
        return messageHeader;
    }

    private Security createSecurityHeader(MessageContext ctx) {
        Security securityHeader = new Security();
        SabreSession session = (SabreSession)ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
        if (session != null) {
            SabreJaxWsRequestBuilder.fillSecurityHeader(securityHeader, session);
        } else {
            EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
            SabreJaxWsRequestBuilder.fillSecurityHeader(ctx, securityHeader, (SabreGdsAccount)accountCtr.getEntity());
        }
        return securityHeader;
    }

    private static void fillSecurityHeader(Security securityHeader, SabreSession session) {
        securityHeader.setBinarySecurityToken(session.getBinarySecurityToken());
    }

    private static void fillSecurityHeader(MessageContext ctx, Security securityHeader, SabreGdsAccount account) {
        Security.UsernameToken usernameToken = new Security.UsernameToken();
        usernameToken.setUsername(account.getAccount());
        usernameToken.setPassword(account.getPassword());
        MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)account.getPassword());
        usernameToken.setOrganization(account.getPrimaryPCC());
        usernameToken.setDomain(USERNAME_TOKEN_DOMAIN);
        securityHeader.setUsernameToken(usernameToken);
    }

    private static String getEndpointAddress(MessageContext ctx) {
        PCIDSSServerExchangeSettings cirSettings = (PCIDSSServerExchangeSettings)ctx.getObject((Enum)IBusGdsSabreContextKeys.CIR_SETTINGS);
        String endPoint = (String)ctx.getObject((Enum)IBusGdsSabreContextKeys.CIR_ENDPOINT);
        if (cirSettings != null && cirSettings.isEnabled() && !StringUtils.isEmpty((String)endPoint)) {
            return CirHelper.getAddressWithEndPoint((PCIDSSServerExchangeSettings)cirSettings, (String)endPoint);
        }
        SabreSession session = (SabreSession)ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
        if (session != null) {
            return session.getEndpointUrl();
        }
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        return ((SabreGdsAccount)accountCtr.getEntity()).getAddress();
    }
}

