/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.sabre.bfm.CabinType;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.AircraftDeckLocation;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.AirPriceRQParameters;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.air.MCOReservationRequestStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.FrequentTravellerAgreements;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.AirItineraryPricingInfoVatAdapter;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreEndorsementBuilder;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.sabre.stl.merchandising.v6.EnumCabinClassLocation;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerPNRB;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SabreServerHelper {
    public static final String FOID = "FOID";

    public static List<String> getFixedNameIdsWithNoFoidsAdded(GetReservationRSType response) {
        return response.getReservation().getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList().stream().filter(passengerPNRB -> passengerPNRB.getSpecialRequests().getGenericSpecialRequestList().stream().noneMatch(sr -> FOID.equals(sr.getCode()))).map(PassengerPNRB::getNameId).map(SabreHelper::fixNameNumber).collect(Collectors.toList());
    }

    public static String agentName(MessageContext ctx) {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        String result = ((SabreGdsAccount)accountCtr.getEntity()).getTransactionExecutor();
        return result;
    }

    public static boolean hasIataCode(DictionaryReference<?> ref) {
        BaseDictionary dict = DictionaryCache.get().resolveReference(ref);
        return dict != null && dict.getCodeVariants().get(CodeSystem.IATA.name()) != null;
    }

    public static DictionaryReference<Airline> findOrCreateAirlineBySpellVariant(String spellVariant) {
        AirlineReference airlineRef = null;
        block2: for (Airline airline : DictionaryCache.get().getAll(Airline.class).values()) {
            for (String sv : airline.getSpellVariants()) {
                if (!sv.equals(spellVariant)) continue;
                airlineRef = airline.toReference();
                break block2;
            }
        }
        if (airlineRef == null) {
            try {
                Airline airline = new Airline();
                airline.getSpellVariants().add(spellVariant);
                airline.getTranslations().put(Locale.ENGLISH, spellVariant);
                airline.setDataSource("Sabre-airlineBySpellVariant");
                DictionaryStorage.get().save((BaseDictionary)airline);
                airlineRef = airline.toReference();
            }
            catch (Exception ex) {
                throw Xeption.forDeveloper((String)"failed saving airline", (Throwable)ex, (Object[])new Object[0]);
            }
        }
        return airlineRef;
    }

    public static String getSpellVariantFrom(String ... stringsToGetSpellVariantFrom) {
        if (stringsToGetSpellVariantFrom == null || stringsToGetSpellVariantFrom.length == 0) {
            throw Xeption.forDeveloper((String)"No info to get spellVariant", (Object[])new Object[0]);
        }
        if (stringsToGetSpellVariantFrom.length != 1) {
            throw Xeption.forDeveloper((String)("stringsToGetSpellVariantFrom length > 1 : " + stringsToGetSpellVariantFrom.length), (Object[])new Object[0]);
        }
        String stringToGetSpellVariantFrom = stringsToGetSpellVariantFrom[0];
        String spellVariant = null;
        if (stringToGetSpellVariantFrom.contains("OPERATED BY /")) {
            spellVariant = stringToGetSpellVariantFrom.replace("OPERATED BY /", "").trim();
        } else if (stringToGetSpellVariantFrom.contains("OPERATED BY")) {
            spellVariant = stringToGetSpellVariantFrom.replace("OPERATED BY", "").trim();
        }
        if (spellVariant == null) {
            throw Xeption.forDeveloper((String)("spellVariant is null, stringToGetSpellVariantFrom = " + stringToGetSpellVariantFrom), (Object[])new Object[0]);
        }
        return spellVariant;
    }

    public static String getPrinterType(MessageContext ctx) {
        String printerTypeFromGetReservationRS = (String)ctx.getObject((Enum)IBusGdsSabreContextKeys.PRINTER_TYPE_FROM_GET_RESERVATION_RS);
        if (printerTypeFromGetReservationRS != null) {
            return printerTypeFromGetReservationRS;
        }
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        return gdsParameters.getSabrePrinterType();
    }

    public static String getCountry(MessageContext ctx) {
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        return SabreServerHelper.getCountry((EntityContainer<SabreGdsAccount>)gdsAccountCtr);
    }

    public static String getCountry(EntityContainer<SabreGdsAccount> gdsAccountCtr) {
        String result = null;
        if (((SabreGdsAccount)gdsAccountCtr.getEntity()).getCountry() != null) {
            Country country = (Country)DictionaryCache.get().resolveReference(((SabreGdsAccount)gdsAccountCtr.getEntity()).getCountry());
            if (country.getCodeVariants().containsKey(CodeSystem.ISO.name())) {
                result = (String)country.getCodeVariants().get(CodeSystem.ISO.name());
            } else if (country.getCodeVariants().containsKey(CodeSystem.IATA.name())) {
                result = (String)country.getCodeVariants().get(CodeSystem.IATA.name());
            }
        }
        if (result == null) {
            result = "RU";
        }
        return result;
    }

    public static List<CabinType> getSearchFlightsSabreCabinTypes(FlightSearchParameters fsp) {
        switch (fsp.getServiceClass()) {
            case ECONOMY: {
                return Arrays.asList(CabinType.ECONOMY, CabinType.PREMIUM_ECONOMY);
            }
            case PREMIUM: {
                return Collections.singletonList(CabinType.PREMIUM_ECONOMY);
            }
            case BUSINESS: {
                return Arrays.asList(CabinType.BUSINESS, CabinType.PREMIUM_BUSINESS);
            }
            case PREMIUM_BUSINESS: {
                return Collections.singletonList(CabinType.PREMIUM_BUSINESS);
            }
            case FIRST: {
                return Arrays.asList(CabinType.FIRST, CabinType.PREMIUM_FIRST);
            }
            case PREMIUM_FIRST: {
                return Collections.singletonList(CabinType.PREMIUM_FIRST);
            }
        }
        throw Xeption.forDeveloper((String)"unexpected class of service {0}", (Object[])new Object[]{fsp.getServiceClass()});
    }

    public static String buildEndorsementVatInfo(Flight flight, DictionaryReference<PassengerType> passengerType) {
        VatDetalization vatDetalization = AirProductVatCalculator.calculateVendorVatDetalization((Object)flight, passengerType, (AirProductVatCalculator.VatProductAdapter)GDSHelper.flightVatAdapter);
        return SabreServerHelper.buildEndorsementVatInfo(vatDetalization, flight, passengerType, GDSHelper.flightVatAdapter);
    }

    public static String buildEndorsementVatInfo(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo pricingInfo, AirPriceRQParameters parameters) {
        AirItineraryPricingInfoVatAdapter adapter = new AirItineraryPricingInfoVatAdapter(parameters);
        VatDetalization vatDetalization = AirProductVatCalculator.calculateVendorVatDetalization((Object)pricingInfo, null, (AirProductVatCalculator.VatProductAdapter)adapter);
        return SabreServerHelper.buildEndorsementVatInfo(vatDetalization, pricingInfo, null, adapter);
    }

    public static String buildEndorsementVatInfo(Product product) {
        AirProductVatCalculator.updateVat((Product)product);
        return SabreServerHelper.buildEndorsementVatInfo(product.getVendorVatDetalization(), product, null, AirProductVatCalculator.productAdapter);
    }

    private static <P, T, ST, S> String buildEndorsementVatInfo(VatDetalization detailing, P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        boolean suppressEndorsement;
        boolean bl = suppressEndorsement = Environment.isPublished(AirProductVatCalculator.VatCalculator.class) && ((AirProductVatCalculator.VatCalculator)Environment.getPublished(AirProductVatCalculator.VatCalculator.class)).suppressEndorsement(adapter.getGdsAccount(product));
        if (suppressEndorsement) {
            return "";
        }
        List vatComponents = detailing.getComponents().stream().filter(c -> c.getRate() != null || "SU".equals(adapter.getValidatingAirline(product).getCode())).collect(Collectors.toList());
        if (vatComponents.isEmpty()) {
            return "";
        }
        Optional<VatComponent> zzTaxVatComponentOpt = vatComponents.stream().filter(c -> SabreServerHelper.hasZZTax(product, c, passengerType, adapter)).findFirst();
        if (zzTaxVatComponentOpt.isPresent()) {
            VatComponent zzVatComponent = zzTaxVatComponentOpt.get();
            BigDecimal zzTaxVatSum = zzVatComponent.getSum();
            zzTaxVatSum = zzTaxVatSum != null && BigDecimal.ZERO.compareTo(zzTaxVatSum) != 0 ? zzTaxVatSum.setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
            BigDecimal otherComponentsVatSum = vatComponents.stream().filter(c -> !c.equals((Object)zzVatComponent)).map(VatComponent::getSum).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            otherComponentsVatSum = BigDecimal.ZERO.compareTo(otherComponentsVatSum) == 0 ? BigDecimal.ZERO : otherComponentsVatSum.setScale(2, RoundingMode.HALF_UP);
            return String.format("NDSA/C%s NDSZZ%s", otherComponentsVatSum, zzTaxVatSum);
        }
        BigDecimal vatSum = vatComponents.stream().map(VatComponent::getSum).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        vatSum = BigDecimal.ZERO.compareTo(vatSum) == 0 ? BigDecimal.ZERO : vatSum.setScale(2, RoundingMode.HALF_UP);
        return String.format("INCL VAT %s%s", vatSum, adapter.getGdsCurrency(product));
    }

    private static <P, T, ST, S> boolean hasZZTax(P product, VatComponent component, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        if (component.getBasisTypes().size() != 1 || !component.getBasisTypes().contains(VatBasisType.TAXES)) {
            return false;
        }
        for (Object tax : adapter.getTaxes(product, passengerType)) {
            if (!"ZZ".equals(adapter.getTaxCode(tax)) || !component.getTaxesUids().contains(adapter.getUid(tax))) continue;
            return true;
        }
        return false;
    }

    private static SabreEndorsementBuilder getSabreEndorsementBuilder() throws Exception {
        String customClassName = System.getProperty(SabreEndorsementBuilder.class.getName() + ".className");
        if (!StringUtils.isBlank((String)customClassName)) {
            return (SabreEndorsementBuilder)Class.forName(customClassName).newInstance();
        }
        return new SabreEndorsementBuilder();
    }

    public static String buildEndorsement(GDSParameters gdsParameters, Flight flight, DictionaryReference<PassengerType> passengerType, SalesContext salesContext, Traveller traveller, Customer customer) throws Exception {
        SabreEndorsementBuilder builder = SabreServerHelper.getSabreEndorsementBuilder();
        builder.fill(gdsParameters, flight, passengerType, salesContext, traveller, customer);
        return builder.build();
    }

    public static String buildEndorsement(GDSParameters gdsParameters, Product product) throws Exception {
        SabreEndorsementBuilder builder = SabreServerHelper.getSabreEndorsementBuilder();
        builder.fill(gdsParameters, product);
        return builder.build();
    }

    public static MCOReservationRequestStatus actionCode2MCOReservationRequestStatus(String actionCode) {
        switch (actionCode) {
            case "HN": 
            case "NN": {
                return MCOReservationRequestStatus.PENDING;
            }
            case "HD": 
            case "HK": 
            case "KK": 
            case "KD": 
            case "HI": 
            case "HS": {
                return MCOReservationRequestStatus.CONFIRMED;
            }
            case "UN": 
            case "UC": 
            case "HX": 
            case "XX": 
            case "NO": {
                return MCOReservationRequestStatus.REJECTED;
            }
        }
        throw Xeption.forDeveloper((String)String.format("unknown actionCode %s", actionCode), (Object[])new Object[0]);
    }

    public static Collection<FrequentTravellerAgreements> getFrequentTravellerAgreementsByOwningCarrier(DictionaryReference<Airline> owningCarrierRef) {
        return DictionaryCache.get().search(FrequentTravellerAgreements.class, DictSearchCriterion.eq((String)FrequentTravellerAgreements.Property.owningCarrier.name(), owningCarrierRef));
    }

    public static AircraftDeckLocation classLocation2AircraftDeckLocation(EnumCabinClassLocation classLocation) {
        if (classLocation == null) {
            return AircraftDeckLocation.MAIN;
        }
        switch (classLocation) {
            case MAINDECK: {
                return AircraftDeckLocation.MAIN;
            }
            case UPPERDECK: {
                return AircraftDeckLocation.UPPER;
            }
            case LOWERDECK: {
                return AircraftDeckLocation.LOWER;
            }
        }
        throw Xeption.forDeveloper((String)"unexpected classLocation {0}", (Object[])new Object[]{classLocation});
    }

    public static boolean isAccountCode(String value, Map<DictionaryReference<Airline>, Collection<String>> accountCodes, Map<DictionaryReference<Airline>, Collection<String>> corporateIds, DictionaryReference<Airline> carrier) {
        if (value == null) {
            return true;
        }
        boolean matchesAccountCode = accountCodes.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()).contains(value);
        boolean matchesCorporateId = corporateIds.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()).contains(value);
        if (matchesAccountCode) {
            if (matchesCorporateId) {
                if (accountCodes.containsKey(carrier)) {
                    if (corporateIds.containsKey(carrier)) {
                        throw Xeption.forDeveloper((String)"can't determine whether {0} is an account code or a corporate id, airline={1}", (Object[])new Object[]{value, carrier.getCode()});
                    }
                    return true;
                }
                if (corporateIds.containsKey(carrier)) {
                    return false;
                }
                throw Xeption.forDeveloper((String)"impossible", (Object[])new Object[0]);
            }
            return true;
        }
        if (matchesCorporateId) {
            return false;
        }
        throw Xeption.forDeveloper((String)"value {0} is neither an account code nor a corporate id", (Object[])new Object[]{value});
    }
}

