/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.addRemark;

import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.AddRemarkRQ;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AddRemarkRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        List remarks = (List)ctx.getObject((Enum)IBusGdsSabreContextKeys.REMARKS);
        if (remarks == null || remarks.isEmpty()) {
            return;
        }
        AddRemarkRQ request = new AddRemarkRQ();
        request.setVersion("2.1.1");
        request.setTimeStamp(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        request.setRemarkList(remarks.stream().map(AddRemarkRQBuilder::convertRemark2sws).collect(Collectors.toList()));
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"AddRemarkLLSRQ");
    }

    private static AddRemarkRQ.Remark convertRemark2sws(Remark remark) {
        AddRemarkRQ.Remark result = new AddRemarkRQ.Remark();
        result.setCode(remark.getCode());
        String text = remark.getText().replaceAll("@", "//").replaceAll("_", ".UN.");
        result.setText(text);
        result.setType(AddRemarkRQ.Remark.Type.convert((String)Optional.ofNullable(remark.getType()).map(Enum::toString).orElse(null)));
        return result;
    }
}

