/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.afs20;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRQ;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class SabreP3DAirPriceRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Product aProduct = (Product)AirProductHelper.getProducts((Reservation)reservation).get(0);
        List<String> brandIds = AirPriceHelper.getBrandIds(aProduct);
        List segmentIds = AirProductHelper.getSegments((Collection)aProduct.getSegmentTariffs()).stream().map(Segment::getGdsId).collect(Collectors.toList());
        OTAAirPriceRQ request = new OTAAirPriceRQ();
        request.setVersion("2.17.0");
        request.setReturnHostCommand(Boolean.TRUE);
        OTAAirPriceRQ.OptionalQualifiers oq = new OTAAirPriceRQ.OptionalQualifiers();
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers pq = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers();
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.FareOptions fo = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.FareOptions();
        fo.setPublic(Boolean.TRUE);
        pq.setFareOptions(fo);
        if (!brandIds.isEmpty()) {
            if (new HashSet<String>(brandIds).size() == 1) {
                if (brandIds.get(0) != null) {
                    OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Brand brand = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Brand();
                    brand.setString(brandIds.get(0));
                    pq.getBrandList().add(brand);
                }
            } else {
                OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.ItineraryOptions io = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.ItineraryOptions();
                int rph = 1;
                for (String brandId : brandIds) {
                    OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.ItineraryOptions.SegmentSelect ss = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.ItineraryOptions.SegmentSelect();
                    ss.setNumber((String)segmentIds.get(rph - 1));
                    io.getSegmentSelectList().add(ss);
                    if (brandId != null) {
                        ss.setRPH(String.valueOf(rph));
                        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Brand brand = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Brand();
                        brand.setRPH(BigInteger.valueOf(rph));
                        brand.setString(brandId);
                        pq.getBrandList().add(brand);
                    }
                    ++rph;
                }
                pq.setItineraryOptions(io);
            }
        }
        oq.setPricingQualifiers(pq);
        request.setOptionalQualifiers(oq);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"OTA_AirPriceLLSRQ");
    }
}

