/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.airBook;

import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.AirBookRQParameters;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.SabreCustomPropertiesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirBookRQ;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class AirBookRQBuilder
extends BaseProcessor {
    private String status;
    private static FastDateFormat DF_SEGMENT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm");

    public void configure(Map<String, String> parameters) {
        this.status = parameters.get("status");
    }

    public void process(MessageContext ctx) throws Exception {
        AirBookRQParameters parameters = (AirBookRQParameters)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.AIR_BOOK_RQ_PARAMETERS);
        OTAAirBookRQ request = this.buildRequest(parameters);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"OTA_AirBookLLSRQ");
    }

    private OTAAirBookRQ buildRequest(AirBookRQParameters parameters) {
        OTAAirBookRQ request = new OTAAirBookRQ();
        request.setVersion("2.2.0");
        request.setReturnHostCommand(Boolean.TRUE);
        for (FlightSegment fs : parameters.getSegments()) {
            String marriageGrpProperty;
            OTAAirBookRQ.FlightSegment sabreFs = new OTAAirBookRQ.FlightSegment();
            sabreFs.setDepartureDateTime(DF_SEGMENT.format(fs.getDateBegin()));
            sabreFs.setArrivalDateTime(DF_SEGMENT.format(fs.getDateEnd()));
            sabreFs.setFlightNumber(fs.getFlightNumber());
            sabreFs.setNumberInParty(Integer.toString(parameters.getTotalSeatCount()));
            sabreFs.setResBookDesigCode(fs.getBookingClass());
            sabreFs.setStatus(this.status);
            sabreFs.setOriginLocation(SabreHelper.getNativeCode((DictionaryReference)fs.getLocationBegin()));
            sabreFs.setDestinationLocation(SabreHelper.getNativeCode((DictionaryReference)fs.getLocationEnd()));
            sabreFs.setMarketingAirlineCode(SabreHelper.getNativeCode((DictionaryReference)fs.getAirline()));
            sabreFs.setMarketingAirlineFlightNumber(fs.getFlightNumber());
            String operatingAirlineCode = SabreHelper.getNativeCodeOrNull((DictionaryReference)fs.getOperatingAirline());
            if (!StringUtils.isBlank((String)operatingAirlineCode)) {
                OTAAirBookRQ.FlightSegment.OperatingAirline airline = new OTAAirBookRQ.FlightSegment.OperatingAirline();
                airline.setCode(operatingAirlineCode);
                sabreFs.setOperatingAirline(airline);
            }
            boolean marriageGroupInd = (marriageGrpProperty = SabreCustomPropertiesHelper.getMarriageGrp(fs)) == null ? true : SabreHelper.marriageGrp2MarriageGrp((String)marriageGrpProperty);
            OTAAirBookRQ.FlightSegment.MarriageGrp marriageGrp = new OTAAirBookRQ.FlightSegment.MarriageGrp();
            marriageGrp.setInd(marriageGroupInd);
            sabreFs.setMarriageGrp(marriageGrp);
            request.getOriginDestinationInformationList().add(sabreFs);
        }
        return request;
    }
}

