/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.airPrice;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AirPriceAncillaryFeesParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        if (flight == null) {
            return;
        }
        OTAAirPriceRS response = (OTAAirPriceRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List<FlightSegment> flightSegments = flight.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toList());
        String gdsEquivCurrencyCode = response.getPriceQuote().getPricedItinerary().getCurrencyCode();
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ArrayList<AncillaryFee> fees = (ArrayList<AncillaryFee>)ctx.getObject((Enum)IBusGdsSabreContextKeys.SABRE_ANCILLARY_FEES);
        if (fees == null) {
            fees = new ArrayList<AncillaryFee>();
            ctx.putObject((Enum)IBusGdsSabreContextKeys.SABRE_ANCILLARY_FEES, fees);
        }
        if (response.getPriceQuote().getMiscInformation().getBaggageInfo() != null) {
            List subCodePropertyList = response.getPriceQuote().getMiscInformation().getBaggageInfo().getSubCodePropertyList();
            Map key2PropertyMap = subCodePropertyList.stream().collect(Collectors.toMap(OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties::getExtendedSubCodeKey, Function.identity()));
            for (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions baggage : ((OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo)response.getPriceQuote().getPricedItinerary().getAirItineraryPricingInfoList().get(0)).getBaggageProvisionList()) {
                if ("--".equals(baggage.getRPH()) || baggage.getPriceInformation() == null || baggage.getSubCodeInfo().getSubCodeForChargesOthers() == null) continue;
                OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties properties = (OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties)key2PropertyMap.get(baggage.getSubCodeInfo().getSubCodeForChargesOthers());
                String passengerTypeCode = baggage.getPassengerType().getCode();
                HashSet<DictionaryReference> passengerTypes = new HashSet<DictionaryReference>();
                if ("ALL".equals(passengerTypeCode)) {
                    for (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info : response.getPriceQuote().getPricedItinerary().getAirItineraryPricingInfoList()) {
                        passengerTypes.add(SabreHelper.resolveNativeCode(PassengerType.class, (String)info.getPassengerTypeQuantity().getCode()));
                    }
                } else {
                    passengerTypes.add(SabreHelper.resolveNativeCode(PassengerType.class, (String)passengerTypeCode));
                }
                for (DictionaryReference passengerType : passengerTypes) {
                    AncillaryFeeType type = GdsDictHelper.parseAncillaryFeeType((String)properties.getAncillaryFeeGroupCode(), (boolean)true);
                    if (type == null) continue;
                    AncillaryFee fee = new AncillaryFee();
                    fee.setGdsDescription(properties.getCommercialNameofBaggageItemType());
                    fee.setType(type);
                    AncillaryFeeDescription desc = GdsDictHelper.findAncillaryFeeDescriptionByServiceName((AncillaryFeeType)fee.getType(), (String)fee.getGdsDescription(), (GdsName)((SabreGdsAccount)accountCtr.getEntity()).getGds());
                    fee.setDescription((DictionaryReference)(desc == null ? null : desc.toReference()));
                    OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions.PriceInformation priceInformation = baggage.getPriceInformation();
                    fee.setBaseAmount(MoneyHelper.buildMoney((String)priceInformation.getBase().getAmount(), (String)priceInformation.getBase().getCurrencyCode()));
                    fee.setEquivalentAmount(AirPriceHelper.getEquivAmount(priceInformation, gdsEquivCurrencyCode));
                    fee.setPassengerType(passengerType);
                    fee.getSegmentNumbers().addAll(this.getSegNumbers(baggage, flightSegments));
                    fee.setGdsId(baggage.getRPH());
                    fees.add(fee);
                }
            }
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.SABRE_ANCILLARY_FEES, fees);
        List flightAncFees = flight.getAncillaryFees().stream().filter(anc -> anc.getType() != AncillaryFeeType.BAGGAGE).collect(Collectors.toList());
        flight.getAncillaryFees().clear();
        flight.getAncillaryFees().addAll(flightAncFees);
    }

    private Set<Integer> getSegNumbers(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions baggage, List<FlightSegment> flightSegments) {
        HashSet<Integer> nums = new HashSet<Integer>();
        int segInd = 0;
        for (FlightSegment fs : flightSegments) {
            List flightNumbers = baggage.getAssociations().getFlightNumberList().stream().map(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions.Associations.FlightNumber::getString).collect(Collectors.toList());
            if (flightNumbers.contains(fs.getFlightNumber())) {
                nums.add(segInd);
            }
            ++segInd;
        }
        return nums;
    }
}

