/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.airPrice;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LuggageDimensionUnit;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.server.gds.sabre.BaggageParserHelper;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AirPriceBaggageInfoParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OTAAirPriceRS response = (OTAAirPriceRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        if (!ctx.hasObject((Enum)IBusGdsSabreContextKeys.LUGGAGE_INFO)) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.LUGGAGE_INFO, new HashMap());
        }
        if (!ctx.hasObject((Enum)IBusGdsSabreContextKeys.CABIN_LUGGAGE_INFO)) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.CABIN_LUGGAGE_INFO, new HashMap());
        }
        Map luggageInfo = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.LUGGAGE_INFO);
        Map cabinLuggageInfo = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CABIN_LUGGAGE_INFO);
        try {
            Map subCodePropertiesMap = response.getPriceQuote().getMiscInformation().getBaggageInfo().getSubCodePropertyList().stream().collect(Collectors.toMap(OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties::getExtendedSubCodeKey, Function.identity()));
            response.getPriceQuote().getPricedItinerary().getAirItineraryPricingInfoList().forEach(info -> {
                luggageInfo.put(info.getPassengerTypeQuantity().getCode(), AirPriceBaggageInfoParser.parseExtendedLuggageInfos(info, "A", subCodePropertiesMap));
                cabinLuggageInfo.put(info.getPassengerTypeQuantity().getCode(), AirPriceBaggageInfoParser.parseExtendedLuggageInfos(info, "B", subCodePropertiesMap));
            });
        }
        catch (Exception ex) {
            IncidentsLog.reportException((String)"failed parsing baggage info", (Throwable)ex);
        }
    }

    private static Map<List<String>, ExtendedLuggageInfo> parseExtendedLuggageInfos(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info, String provisionType, Map<String, OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties> subCodePropertiesMap) {
        HashMap<List<String>, ExtendedLuggageInfo> result = new HashMap<List<String>, ExtendedLuggageInfo>();
        info.getBaggageProvisionList().stream().filter(bp -> provisionType.equals(bp.getProvisionType())).forEach(bp -> bp.getAssociations().getCarrierCodeList().stream().map(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions.Associations.CarrierCode::getRPH).forEach(rph -> {
            OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions.WeightLimit weightLimit;
            String carrierCode = ((OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions.Associations.CarrierCode)Streams.single(bp.getAssociations().getCarrierCodeList().stream().filter(cc -> rph.equals(cc.getRPH())))).getString();
            String departureDate = ((OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions.Associations.DepartureDate)Streams.single(bp.getAssociations().getDepartureDateList().stream().filter(cc -> rph.equals(cc.getRPH())))).getString();
            String flightNumber = ((OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions.Associations.FlightNumber)Streams.single(bp.getAssociations().getFlightNumberList().stream().filter(cc -> rph.equals(cc.getRPH())))).getString();
            String originLocation = ((OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions.Associations.OriginLocation)Streams.single(bp.getAssociations().getOriginLocationList().stream().filter(cc -> rph.equals(cc.getRPH())))).getLocationCode();
            String destinationLocation = ((OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions.Associations.DestinationLocation)Streams.single(bp.getAssociations().getDestinationLocationList().stream().filter(cc -> rph.equals(cc.getRPH())))).getLocationCode();
            ExtendedLuggageInfo luggageInfo = new ExtendedLuggageInfo();
            if (bp.getNumPiecesBDI() != null) {
                luggageInfo.setPieces(Integer.valueOf(Integer.parseInt(bp.getNumPiecesBDI())));
            }
            boolean weightSet = false;
            if (bp.getSubCodeInfo().getSubCodeForAllowanceList() != null) {
                OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties subCodeProperties = (OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties)subCodePropertiesMap.get(((OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions.SubCodeInfo.SubCodeForAllowance)CollectionUtil.single((Collection)bp.getSubCodeInfo().getSubCodeForAllowanceList())).getString());
                OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties.SizeWeightInfo sizeWeightInfo = subCodeProperties.getSizeWeightInfo();
                OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties.SizeWeightInfo.MaximumWeightInAlternate maximumWeightInAlternate = sizeWeightInfo.getMaximumWeightInAlternate();
                if (maximumWeightInAlternate != null) {
                    luggageInfo.setWeight(Integer.valueOf(Integer.parseInt(maximumWeightInAlternate.getString())));
                    luggageInfo.setWeightUnit((DictionaryReference)DictHelper.findLuggageUnitBySpellVariant((String)maximumWeightInAlternate.getUnits()).toReference());
                    weightSet = true;
                } else {
                    OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties.SizeWeightInfo.MaximumWeight maximumWeight = sizeWeightInfo.getMaximumWeight();
                    if (maximumWeight != null) {
                        luggageInfo.setWeight(Integer.valueOf(Integer.parseInt(maximumWeight.getString())));
                        luggageInfo.setWeightUnit((DictionaryReference)DictHelper.findLuggageUnitBySpellVariant((String)maximumWeight.getUnits()).toReference());
                        weightSet = true;
                    } else {
                        OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties.DescriptionOne descriptionOne = subCodeProperties.getDescriptionOne();
                        if (descriptionOne != null && descriptionOne.getText() != null) {
                            BaggageParserHelper.parseKgWeight(descriptionOne.getText(), luggageInfo);
                            if (luggageInfo.getWeight() != null && luggageInfo.getWeightUnit() != null) {
                                weightSet = true;
                            }
                        }
                    }
                }
                OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties.SizeWeightInfo.MaximumSizeInAlternate maximumSizeInAlternate = sizeWeightInfo.getMaximumSizeInAlternate();
                if (maximumSizeInAlternate != null) {
                    luggageInfo.setDimensionsSum(Integer.valueOf(Integer.parseInt(maximumSizeInAlternate.getString())));
                    luggageInfo.setDimensionUnit(AirPriceBaggageInfoParser.parseLuggageDimensionUnit(maximumSizeInAlternate.getUnits()));
                } else {
                    OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties.SizeWeightInfo.MaximumSize maximumSize = sizeWeightInfo.getMaximumSize();
                    if (maximumSize != null) {
                        luggageInfo.setDimensionsSum(Integer.valueOf(Integer.parseInt(maximumSize.getString())));
                        luggageInfo.setDimensionUnit(AirPriceBaggageInfoParser.parseLuggageDimensionUnit(maximumSize.getUnits()));
                    } else {
                        OTAAirPriceRS.PriceQuote.MiscInformation.BaggageInfo.SubCodeProperties.DescriptionTwo descriptionTwo = subCodeProperties.getDescriptionTwo();
                        if (descriptionTwo != null && descriptionTwo.getText() != null) {
                            BaggageParserHelper.parseCmSize(descriptionTwo.getText(), luggageInfo);
                        }
                    }
                }
            }
            if (!weightSet && (weightLimit = bp.getWeightLimit()) != null) {
                luggageInfo.setWeight(Integer.valueOf(Integer.parseInt(weightLimit.getString())));
                luggageInfo.setWeightUnit((DictionaryReference)DictHelper.findLuggageUnitBySpellVariant((String)weightLimit.getUnits()).toReference());
            }
            result.put(Arrays.asList(carrierCode, departureDate, flightNumber, originLocation, destinationLocation), luggageInfo);
        }));
        return result;
    }

    private static LuggageDimensionUnit parseLuggageDimensionUnit(String unit) {
        switch (unit) {
            case "C": {
                return LuggageDimensionUnit.CENTIMETER;
            }
            case "I": {
                return LuggageDimensionUnit.INCH;
            }
        }
        throw Xeption.forDeveloper((String)"unexpected unit {0}", (Object[])new Object[]{unit});
    }
}

