/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.airPrice;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class AirPriceHelper {
    public static final String VALIDATION_METHOD_TCH = "TCH";
    private static final Pattern P_PASSENGER_TYPE_NOT_APPLICABLE = Pattern.compile("(?<originalPtc>[A-Z0-9]{3}) NOT APPLICABLE - (?<usedPtc>[A-Z0-9]{3}) FARE USED - VERIFY RESTRICTIONS");

    public static String buildCommissionQualifier(Commission commission, String equivCurrencyCode) {
        StringBuilder sb = new StringBuilder();
        if (commission != null) {
            if (commission.getRate() != null) {
                BigDecimal value = BigDecimal.valueOf(commission.getRate());
                value = value.setScale(2, RoundingMode.HALF_UP);
                sb.append("KP");
                sb.append(value);
            } else {
                BigDecimal value = commission.getEquivalentAmount();
                value = value.setScale(AirPriceHelper.getIataDecimalPlacesForCurrency(Objects.requireNonNull(DictHelper.getCurrencyInfoByAnyCode((String)equivCurrencyCode))), RoundingMode.HALF_UP);
                sb.append("K");
                sb.append(value);
            }
        }
        return sb.toString();
    }

    public static int getIataDecimalPlacesForCurrency(CurrencyInfo currencyInfo) {
        if (currencyInfo.getIataDecimalPlaces() == null) {
            throw Xeption.forDeveloper((String)"sabre decimal places is not defined for currency {0}", (Object[])new Object[]{currencyInfo});
        }
        return currencyInfo.getIataDecimalPlaces();
    }

    public static PenaltiesInfo parsePenaltiesInfo(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info) {
        PenaltiesInfo penaltiesInfo = new PenaltiesInfo();
        block12: for (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.SpecificPenalty penalty : info.getSpecificPenaltyList()) {
            OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.SpecificPenalty.PenaltyInformation penaltyInformation = penalty.getPenaltyInformation();
            switch (penaltyInformation.getType()) {
                case "RPBD": {
                    AirPriceHelper.processPenaltyInformation(penaltyInformation, arg_0 -> ((PenaltiesInfo)penaltiesInfo).setRefundableBeforeDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setRefundBeforeDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setCat16RefundableBefore(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setConditionsApplyRefundableBefore(arg_0));
                    continue block12;
                }
                case "RPAD": {
                    AirPriceHelper.processPenaltyInformation(penaltyInformation, arg_0 -> ((PenaltiesInfo)penaltiesInfo).setRefundableAfterDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setRefundAfterDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setCat16RefundableAfter(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setConditionsApplyRefundableAfter(arg_0));
                    continue block12;
                }
                case "CPBD": {
                    AirPriceHelper.processPenaltyInformation(penaltyInformation, arg_0 -> ((PenaltiesInfo)penaltiesInfo).setExchangableBeforeDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setExchangeBeforeDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setCat16ExchangableBefore(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setConditionsApplyExchangableBefore(arg_0));
                    continue block12;
                }
                case "CPAD": {
                    AirPriceHelper.processPenaltyInformation(penaltyInformation, arg_0 -> ((PenaltiesInfo)penaltiesInfo).setExchangableAfterDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setExchangeAfterDeparture(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setCat16ExchangableAfter(arg_0), arg_0 -> ((PenaltiesInfo)penaltiesInfo).setConditionsApplyExchangableAfter(arg_0));
                    continue block12;
                }
            }
            throw Xeption.forDeveloper((String)"unexpected type {0}", (Object[])new Object[]{penalty.getPenaltyInformation().getType()});
        }
        return penaltiesInfo;
    }

    private static void processPenaltyInformation(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.SpecificPenalty.PenaltyInformation penaltyInformation, Consumer<Boolean> possibleSetter, Consumer<Money> moneySetter, Consumer<Boolean> cat16Setter, Consumer<Boolean> conditionsApplySetter) {
        if (!StringUtils.isBlank((String)penaltyInformation.getAmount())) {
            possibleSetter.accept(Boolean.TRUE);
            moneySetter.accept(MoneyHelper.buildMoney((BigDecimal)new BigDecimal(penaltyInformation.getAmount()), (String)penaltyInformation.getCurrency()));
        } else {
            possibleSetter.accept(Boolean.FALSE);
        }
        cat16Setter.accept(penaltyInformation.getCat16());
        conditionsApplySetter.accept(Boolean.TRUE.equals(penaltyInformation.getNotApplicable()));
    }

    public static BigDecimal getEquivFareAmount(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare fare) {
        if (fare.getEquivFare() == null) {
            return new BigDecimal(fare.getBaseFare().getAmount());
        }
        return new BigDecimal(fare.getEquivFare().getAmount());
    }

    public static List<String> getBookingClasses(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info, List<OTAAirPriceRS.PriceQuote.MiscInformation.HeaderInformation> headerInformationList) {
        OTAAirPriceRS.PriceQuote.MiscInformation.HeaderInformation headerInformation = headerInformationList.stream().filter(hi -> hi.getSolutionSequenceNmbr().equals(info.getSolutionSequenceNmbr())).findAny().orElseThrow(() -> Xeption.forDeveloper((String)"header information not found for solution sequence number {0}", (Object[])new Object[]{info.getSolutionSequenceNmbr()}));
        return headerInformation.getBargainFinder().getAlternateBookingList().stream().map(OTAAirPriceRS.PriceQuote.MiscInformation.HeaderInformation.BargainFinder.AlternateBooking::getResBookDesigCode).sorted().map(s -> s.substring(s.length() - 1)).collect(Collectors.toList());
    }

    public static BigDecimal getEquivAmount(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.BaggageProvisions.PriceInformation priceInformation, String equivCurrencyCode) {
        if (priceInformation.getEquiv() == null) {
            if (!MiscUtil.equals((Object)priceInformation.getBase().getCurrencyCode(), (Object)equivCurrencyCode)) {
                throw Xeption.forDeveloper((String)"no EquivFare and BaseFare/@CurrencyCode is not an equivalent currency", (Object[])new Object[0]);
            }
            return new BigDecimal(priceInformation.getBase().getAmount());
        }
        return new BigDecimal(priceInformation.getEquiv().getAmount());
    }

    public static List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.FareCalculationBreakdown> getValidFareCalculationBreakdownList(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info) {
        ArrayList<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.FareCalculationBreakdown> result = new ArrayList<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.FareCalculationBreakdown>();
        for (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.FareCalculationBreakdown fcb : info.getFareCalculationBreakdownList()) {
            if (!StringUtils.isBlank((String)fcb.getFareBasis().getSurfaceSegment())) continue;
            result.add(fcb);
        }
        return result;
    }

    public static List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown> getValidPTCFareBreakdownList(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info) {
        ArrayList<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown> result = new ArrayList<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown>();
        for (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown ptcfb : info.getPTCFareBreakdownList()) {
            if (!StringUtils.isBlank((String)ptcfb.getFareBasis().getSurfaceSegment())) continue;
            result.add(ptcfb);
        }
        return result;
    }

    private static List<FarePricingParameters> getFarePricingParameters(Flight flight, DictionaryReference<PassengerType> passengerType) {
        return FlightHelper.getSegments((Flight)flight).stream().map(fs -> Optional.ofNullable(FlightHelper.getFareInfo((FlightSegment)fs, (DictionaryReference)passengerType)).map(FareInfo::getFareDetails).map(FareDetails::getPricingParameters).orElse(null)).collect(Collectors.toList());
    }

    public static List<String> getBrandIds(Flight flight, DictionaryReference<PassengerType> passengerType) {
        return AirPriceHelper.getFarePricingParameters(flight, passengerType).stream().map(pp -> pp != null ? pp.getBrandId() : null).collect(Collectors.toList());
    }

    public static List<String> getFareBasises(Flight flight, DictionaryReference<PassengerType> passengerType) {
        return FlightHelper.getSegments((Flight)flight).stream().map(fs -> Optional.ofNullable(FlightHelper.getFareInfo((FlightSegment)fs, (DictionaryReference)passengerType)).orElseThrow(() -> Xeption.forDeveloper((String)"fare info not found for type {0}", (Object[])new Object[]{passengerType}))).map(FareInfo::getFareBasis).collect(Collectors.toList());
    }

    public static List<String> getSmartPriceFareBasises(Flight flight, DictionaryReference<PassengerType> passengerType) {
        return FlightHelper.getSegments((Flight)flight).stream().map(fs -> Optional.ofNullable(FlightHelper.getFareInfo((FlightSegment)fs, (DictionaryReference)passengerType)).orElseThrow(() -> Xeption.forDeveloper((String)"fare info not found for type {0}", (Object[])new Object[]{passengerType}))).map(FareInfo::getFareBasis).map(AirPriceHelper::stripTicketDesignator).collect(Collectors.toList());
    }

    public static String stripTicketDesignator(String fareBasis) {
        int i = fareBasis.indexOf(47);
        return i > 0 ? fareBasis.substring(0, i) : fareBasis;
    }

    public static boolean getPublicFare(Flight flight, DictionaryReference<PassengerType> passengerType) {
        List values = AirPriceHelper.getFarePricingParameters(flight, passengerType).stream().map(pp -> pp != null ? pp.getPublicFare() : null).collect(Collectors.toList());
        if (new HashSet(values).size() > 1) {
            throw Xeption.forDeveloper((String)"conflict for passengerType {0}, values = {1}", (Object[])new Object[]{passengerType, values});
        }
        return Boolean.TRUE.equals(values.get(0));
    }

    public static boolean getRefundableAny(Flight flight, DictionaryReference<PassengerType> passengerType) {
        List values = AirPriceHelper.getFarePricingParameters(flight, passengerType).stream().map(pp -> pp != null ? pp.getRefundableAny() : null).collect(Collectors.toList());
        if (new HashSet(values).size() > 1) {
            throw Xeption.forDeveloper((String)"conflict for passengerType {0}, values = {1}", (Object[])new Object[]{passengerType, values});
        }
        return Boolean.TRUE.equals(values.get(0));
    }

    private static List<FarePricingParameters> getFarePricingParameters(Product product) {
        return AirProductHelper.getSegments((Collection)product.getSegmentTariffs()).stream().map(s -> Optional.ofNullable(s.getFareDetails()).map(FareDetails::getPricingParameters).orElse(null)).collect(Collectors.toList());
    }

    public static List<String> getBrandIds(Product product) {
        return AirPriceHelper.getFarePricingParameters(product).stream().map(pp -> pp != null ? pp.getBrandId() : null).collect(Collectors.toList());
    }

    public static List<String> getFareBasises(Product product) {
        return AirProductHelper.getProductSegmentsStream((Product)product).map(Segment::getFareBasis).collect(Collectors.toList());
    }

    public static List<String> getSmartPriceFareBasises(Product product) {
        return AirProductHelper.getProductSegmentsStream((Product)product).map(Segment::getFareBasis).map(AirPriceHelper::stripTicketDesignator).collect(Collectors.toList());
    }

    public static boolean getPublicFare(Product product) {
        List values = AirPriceHelper.getFarePricingParameters(product).stream().map(pp -> pp != null ? pp.getPublicFare() : null).collect(Collectors.toList());
        if (new HashSet(values).size() > 1) {
            throw Xeption.forDeveloper((String)"conflict for product {0}, values = {1}", (Object[])new Object[]{product.getUid(), values});
        }
        return Boolean.TRUE.equals(values.get(0));
    }

    public static boolean getRefundableAny(Product product) {
        List values = AirPriceHelper.getFarePricingParameters(product).stream().map(pp -> pp != null ? pp.getRefundableAny() : null).collect(Collectors.toList());
        if (new HashSet(values).size() > 1) {
            throw Xeption.forDeveloper((String)"conflict for product {0}, values = {1}", (Object[])new Object[]{product.getUid(), values});
        }
        return Boolean.TRUE.equals(values.get(0));
    }

    public static String getSubstitutePtc(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info) {
        OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Warnings warnings = info.getItinTotalFare().getWarnings();
        if (warnings != null && warnings.getWarningList() != null) {
            for (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Warnings.Warning warning : warnings.getWarningList()) {
                Matcher m;
                if (StringUtils.isBlank((String)warning.getShortText()) || !(m = P_PASSENGER_TYPE_NOT_APPLICABLE.matcher(warning.getShortText())).matches()) continue;
                return m.group("usedPtc");
            }
        }
        return null;
    }

    public static class UniqueQualifiers {
        public String commission;
        public String endorsement;
        public Boolean suOnBsp;
        public List<String> brandIds;
        public List<String> smartPriceFareBasises;
        public boolean publicFare;
        public boolean refundableAny;
        public boolean privateFare;
        public String vatInfo;

        public int hashCode() {
            return MiscUtil.hash((Object[])new Object[]{this.commission, this.endorsement, this.suOnBsp, this.brandIds, this.smartPriceFareBasises, this.publicFare, this.refundableAny, this.privateFare, this.vatInfo});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UniqueQualifiers)) {
                return false;
            }
            UniqueQualifiers that = (UniqueQualifiers)obj;
            return MiscUtil.equals((Object)this.commission, (Object)that.commission) && MiscUtil.equals((Object)this.endorsement, (Object)that.endorsement) && this.suOnBsp != Boolean.TRUE && that.suOnBsp != Boolean.TRUE && MiscUtil.equals(this.brandIds, that.brandIds) && MiscUtil.equals(this.smartPriceFareBasises, that.smartPriceFareBasises) && this.publicFare == that.publicFare && this.refundableAny == that.refundableAny && this.privateFare == that.privateFare && MiscUtil.equals((Object)this.vatInfo, (Object)that.vatInfo);
        }
    }
}

