/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.airPrice;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class AirPriceLastTicketingDateParser
extends BaseProcessor {
    private static final Map<Pattern, String> LAST_TICKETING_DATE_FORMATTERS = new HashMap<Pattern, String>();

    public void process(MessageContext ctx) throws Exception {
        OTAAirPriceRS response = (OTAAirPriceRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Date oldDate = (Date)ctx.getObject((Enum)IBusGdsSabreContextKeys.LAST_TICKETING_DATE);
        Date newDate = this.parseLastTicketingDate(response, ctx);
        if (oldDate == null) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.LAST_TICKETING_DATE, (Object)newDate);
        } else if (newDate != null) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.LAST_TICKETING_DATE, (Object)(oldDate.before(newDate) ? oldDate : newDate));
        }
    }

    protected Date parseLastTicketingDate(OTAAirPriceRS response, MessageContext ctx) {
        if (response.getPriceQuote().getMiscInformation().getHeaderInformationList() == null) {
            return null;
        }
        String lastTicketingDateStr = null;
        for (OTAAirPriceRS.PriceQuote.MiscInformation.HeaderInformation hi : response.getPriceQuote().getMiscInformation().getHeaderInformationList()) {
            if (hi.getLastTicketingDate() == null) continue;
            lastTicketingDateStr = hi.getLastTicketingDate();
            break;
        }
        if (StringUtils.isBlank(lastTicketingDateStr)) {
            return null;
        }
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Pcc ticketingPcc = PccHelper.getTicketingPcc((GDSParameters)gdsParameters, (EntityReference)salesContext.getSalesPoint(), (GdsName)((SabreGdsAccount)accountCtr.getEntity()).getGds());
        if (ticketingPcc == null) {
            ticketingPcc = SabreHelper.getPcc((SabreGdsAccount)((SabreGdsAccount)accountCtr.getEntity()), (SalesContext)salesContext);
        }
        ZoneId pccTimeZone = GDSHelper.getPccTimeZone((Pcc)ticketingPcc);
        for (Map.Entry<Pattern, String> entry : LAST_TICKETING_DATE_FORMATTERS.entrySet()) {
            if (!entry.getKey().matcher(lastTicketingDateStr).matches()) continue;
            return Date.from(SabreHelper.parseDateTimeWithoutYear((String)lastTicketingDateStr, (String)entry.getValue(), (ZoneId)pccTimeZone).toInstant());
        }
        throw Xeption.forDeveloper((String)"unknown last ticketing date format: '{}'", (Object[])new Object[]{lastTicketingDateStr});
    }

    static {
        LAST_TICKETING_DATE_FORMATTERS.put(Pattern.compile("\\d{2}-\\d{2}T\\d{2}:\\d{2}"), "MM-dd'T'HH:mm");
        LAST_TICKETING_DATE_FORMATTERS.put(Pattern.compile("\\d{2}-\\d{2}"), "MM-dd");
    }
}

