/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.airPrice;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.AirPriceRQParameters;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.TripartitePublicFareDiscount;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRQ;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class AirPriceRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirPriceRQParameters parameters = (AirPriceRQParameters)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.AIR_PRICE_RQ_PARAMETERS);
        OTAAirPriceRQ request = this.buildRequest(parameters);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"OTA_AirPriceLLSRQ");
    }

    private OTAAirPriceRQ buildRequest(AirPriceRQParameters parameters) {
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.ItineraryOptions.SegmentSelect ss;
        OTAAirPriceRQ request = new OTAAirPriceRQ();
        request.setVersion("2.17.0");
        request.setReturnHostCommand(Boolean.TRUE);
        request.setPriceRequestInformationRetain(Boolean.valueOf(parameters.isRetain()));
        OTAAirPriceRQ.OptionalQualifiers oq = new OTAAirPriceRQ.OptionalQualifiers();
        if (parameters.getCarrier() != null) {
            OTAAirPriceRQ.OptionalQualifiers.FlightQualifiers fq = new OTAAirPriceRQ.OptionalQualifiers.FlightQualifiers();
            OTAAirPriceRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs vp = new OTAAirPriceRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs();
            vp.setAirline(SabreHelper.getNativeCode((DictionaryReference)parameters.getCarrier()));
            fq.setVendorPrefs(vp);
            oq.setFlightQualifiers(fq);
        }
        if (parameters.getCommission() != null) {
            BigDecimal value;
            if (oq.getMiscQualifiers() == null) {
                oq.setMiscQualifiers(new OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers());
            }
            OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.Commission c = new OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.Commission();
            if (parameters.getCommission().getRate() != null) {
                value = BigDecimal.valueOf(parameters.getCommission().getRate());
                value = value.setScale(2, RoundingMode.HALF_UP);
                c.setPercent(value.toString());
            } else {
                value = parameters.getCommission().getEquivalentAmount();
                value = value.setScale(AirPriceHelper.getIataDecimalPlacesForCurrency(DictHelper.getCurrencyInfoByAnyCode((String)parameters.getGdsCurrencyCode())), RoundingMode.HALF_UP);
                c.setAmount(value.toString());
            }
            oq.getMiscQualifiers().setCommission(c);
        }
        if (!StringUtils.isBlank((String)parameters.getEndorsement())) {
            if (oq.getMiscQualifiers() == null) {
                oq.setMiscQualifiers(new OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers());
            }
            OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.Endorsements end = new OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.Endorsements();
            end.setText(parameters.getEndorsement());
            oq.getMiscQualifiers().setEndorsements(end);
        }
        if (!StringUtils.isBlank((String)parameters.getTourCode()) || parameters.getTripartiteContractDetails() != null && parameters.getTripartiteContractDetails().getTourcodeType() != null) {
            if (oq.getMiscQualifiers() == null) {
                oq.setMiscQualifiers(new OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers());
            }
            OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.TourCode tc = new OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.TourCode();
            if (parameters.getTripartiteContractDetails() != null && parameters.getTripartiteContractDetails().getTourcodeType() != null) {
                tc.setText("");
                switch (parameters.getTripartiteContractDetails().getTourcodeType()) {
                    case INDICATOR_I: {
                        OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.TourCode.SuppressFareReplaceWithIT ui = new OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.TourCode.SuppressFareReplaceWithIT();
                        ui.setInd(true);
                        tc.setSuppressFareReplaceWithIT(ui);
                        break;
                    }
                    case INDICATOR_X: {
                        OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.TourCode.SuppressITSupressFare ux = new OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.TourCode.SuppressITSupressFare();
                        ux.setInd(true);
                        tc.setSuppressITSupressFare(ux);
                        break;
                    }
                    case INDICATOR_B: {
                        OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.TourCode.SuppressFareReplaceWithBT ub = new OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.TourCode.SuppressFareReplaceWithBT();
                        ub.setInd(true);
                        tc.setSuppressFareReplaceWithBT(ub);
                        break;
                    }
                    case INDICATOR_N: {
                        OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.TourCode.SuppressIT un = new OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers.TourCode.SuppressIT();
                        un.setInd(true);
                        tc.setSuppressIT(un);
                        break;
                    }
                }
            }
            if (!StringUtils.isBlank((String)parameters.getTourCode())) {
                tc.setText(parameters.getTourCode());
            }
            oq.getMiscQualifiers().setTourCode(tc);
        }
        if (!StringUtils.isBlank((String)parameters.getValidationMethod())) {
            if (oq.getMiscQualifiers() == null) {
                oq.setMiscQualifiers(new OTAAirPriceRQ.OptionalQualifiers.MiscQualifiers());
            }
            oq.getMiscQualifiers().setValidationMethod(parameters.getValidationMethod());
        }
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers pq = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers();
        if (!parameters.getAccountCodes().isEmpty()) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Account acc = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Account();
            acc.getCodeList().addAll(parameters.getAccountCodes());
            pq.setAccount(acc);
        }
        if (!StringUtils.isBlank((String)parameters.getCorporateId())) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Corporate corporate = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Corporate();
            corporate.getIDList().add(parameters.getCorporateId());
            pq.setCorporate(corporate);
        }
        if (parameters.isLowestFare()) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.BargainFinder bf = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.BargainFinder();
            if (parameters.isLowestFareRebook()) {
                bf.setRebook(Boolean.TRUE);
            }
            pq.setBargainFinder(bf);
        }
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.ItineraryOptions io = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.ItineraryOptions();
        pq.setItineraryOptions(io);
        TripartitePublicFareDiscount publicFareDiscount = null;
        if (parameters.getTripartiteContractDetails() != null) {
            publicFareDiscount = parameters.getTripartiteContractDetails().getPublicFareDiscount();
        }
        if (parameters.getTripartiteContractDetails() != null && publicFareDiscount != null) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.CommandPricing cp = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.CommandPricing();
            AirPriceRQBuilder.populateCommandPricingWithPublicFareDiscountDetails(cp, publicFareDiscount, parameters.getGdsCurrencyCode());
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.CommandPricing.FareBasis fb = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.CommandPricing.FareBasis();
            fb.setTicketDesignator("");
            cp.setFareBasis(fb);
            pq.getCommandPricingList().add(cp);
        }
        if (parameters.getResidentCountry() != null) {
            pq.setPassengerStatus(String.format("RY/%s", SabreHelper.getNativeCode((DictionaryReference)parameters.getResidentCountry())));
        }
        for (MiscUtil.Pair passengerType : parameters.getPassengerTypes()) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.PassengerType pt = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.PassengerType();
            pt.setCode((String)passengerType.getFirst());
            if (passengerType.getSecond() != null) {
                pt.setQuantity(((Integer)passengerType.getSecond()).toString());
            } else {
                pt.setQuantity("");
            }
            pq.getPassengerTypeList().add(pt);
        }
        for (String nameNumber : parameters.getNameNumbers()) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.NameSelect ns = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.NameSelect();
            ns.setNameNumber(nameNumber);
            pq.getNameSelectList().add(ns);
        }
        if (parameters.isExemptAllTaxes()) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Taxes taxes = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Taxes();
            taxes.getTaxExemptList().add(new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Taxes.TaxExempt());
            pq.setTaxes(taxes);
        }
        if (!parameters.getBrandIds().isEmpty()) {
            if (new HashSet(parameters.getBrandIds()).size() == 1) {
                if (parameters.getBrandIds().get(0) != null) {
                    OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Brand brand = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Brand();
                    brand.setString((String)parameters.getBrandIds().get(0));
                    pq.getBrandList().add(brand);
                }
            } else {
                int rph = 1;
                for (String brandId : parameters.getBrandIds()) {
                    ss = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.ItineraryOptions.SegmentSelect();
                    ss.setNumber((String)parameters.getSegmentNumbers().get(rph - 1));
                    io.getSegmentSelectList().add(ss);
                    if (brandId != null) {
                        ss.setRPH(String.valueOf(rph));
                        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Brand brand = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Brand();
                        brand.setRPH(BigInteger.valueOf(rph));
                        brand.setString(brandId);
                        pq.getBrandList().add(brand);
                    }
                    ++rph;
                }
            }
        }
        if (!parameters.getSmartPriceFareBasises().isEmpty()) {
            if (parameters.getBrandIds().stream().anyMatch(Objects::nonNull)) {
                throw Xeption.forDeveloper((String)"can't combine brands and SmartPrice", (Object[])new Object[0]);
            }
            int rph = 1;
            for (String fareBasis : parameters.getSmartPriceFareBasises()) {
                ss = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.ItineraryOptions.SegmentSelect();
                ss.setNumber((String)parameters.getSegmentNumbers().get(rph - 1));
                ss.setRPH(String.valueOf(rph));
                io.getSegmentSelectList().add(ss);
                OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.SpecificFare specificFare = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.SpecificFare();
                specificFare.setRPH(String.valueOf(rph));
                specificFare.setFareBasis(fareBasis);
                pq.getSpecificFareList().add(specificFare);
                ++rph;
            }
        }
        if (parameters.isPublicFare()) {
            if (pq.getFareOptions() == null) {
                pq.setFareOptions(new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.FareOptions());
            }
            pq.getFareOptions().setPublic(Boolean.TRUE);
        }
        if (parameters.isRefundableAny()) {
            if (pq.getSpecificPenalty() == null) {
                pq.setSpecificPenalty(new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.SpecificPenalty());
            }
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.SpecificPenalty.Refundable refundable = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.SpecificPenalty.Refundable();
            refundable.setAny(Boolean.TRUE);
            pq.getSpecificPenalty().setRefundable(refundable);
        }
        oq.setPricingQualifiers(pq);
        request.setOptionalQualifiers(oq);
        return request;
    }

    private static void populateCommandPricingWithPublicFareDiscountDetails(OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.CommandPricing cp, TripartitePublicFareDiscount publicFareDiscount, String gdsCurrencyCode) {
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.CommandPricing.Discount d = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.CommandPricing.Discount();
        if (publicFareDiscount.isRate()) {
            d.setPercent(publicFareDiscount.getValue().setScale(2, RoundingMode.HALF_UP).toString());
        } else {
            d.setAmount(publicFareDiscount.getValue().setScale(AirPriceHelper.getIataDecimalPlacesForCurrency(DictHelper.getCurrencyInfoByAnyCode((String)gdsCurrencyCode)), RoundingMode.HALF_UP).toString());
        }
        if (!StringUtils.isBlank((String)publicFareDiscount.getTicketDesignator())) {
            d.setAuthCode(publicFareDiscount.getTicketDesignator());
        }
        cp.setDiscount(d);
    }
}

