/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.autorefund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetails;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetailsFareComponent;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.sabrexml.StructureFareRulesRQ;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StructureFareRulesRQBuilder
extends BaseProcessor {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    public void process(MessageContext ctx) {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map<String, List<PriceQuoteDetails>> priceQuoteByPassengerType = response.getPriceQuote().getPriceQuoteInfo().getGetResultsChoiceCG().getDetailList().stream().collect(Collectors.groupingBy(GetReservationHelper::deteminePassengerTypeCode));
        List products = GDSHelper.getProducts((Reservation)res, (ProductCategory[])new ProductCategory[]{ProductCategory.AIR});
        List<Segment> segments = ((Product)products.get(0)).getSegmentTariffs().stream().flatMap(segmentTariff -> segmentTariff.getSegments().stream()).collect(Collectors.toList());
        Map<String, Integer> countByPassengerTypeMap = products.stream().collect(Collectors.toMap(product -> SabreHelper.getNativeCode((DictionaryReference)product.getPassengerType()), product -> 1, Integer::sum));
        StructureFareRulesRQ request = new StructureFareRulesRQ();
        Pcc ticketingPcc = PccHelper.findPcc((EntityReference)((Product)products.get(0)).getSalesPoint(), (String)((Product)products.get(0)).getPcc(), (GdsName)GdsName.SABRE);
        ZoneId pccTimeZone = GDSHelper.getPccTimeZone((Pcc)ticketingPcc);
        request.setPriceRequestInformation(this.getPriceRequestInformation(countByPassengerTypeMap, (Product)products.get(0), pccTimeZone));
        List<StructureFareRulesRQ.OriginDestinationOption> originDestinationOptions = this.getOriginDestinationOptions(res, segments, priceQuoteByPassengerType, pccTimeZone);
        this.checkOnMarriageSegments(segments, originDestinationOptions);
        request.setAirItineraryList(originDestinationOptions);
        request.setVersion("1.0.5");
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"StructureFareRulesRQ");
    }

    private List<StructureFareRulesRQ.OriginDestinationOption> getOriginDestinationOptions(Reservation res, List<Segment> segments, Map<String, List<PriceQuoteDetails>> priceQuoteByPassengerType, ZoneId pccTimeZone) {
        ArrayList<StructureFareRulesRQ.OriginDestinationOption> destinationOptions = new ArrayList<StructureFareRulesRQ.OriginDestinationOption>();
        for (int i = 0; i < segments.size(); ++i) {
            Segment segment = segments.get(i);
            StructureFareRulesRQ.OriginDestinationOption originDestinationOption = new StructureFareRulesRQ.OriginDestinationOption();
            String segmentNumber = segment.getGdsId();
            originDestinationOption.setFlightSegmentSegmentNumber(Short.valueOf(segmentNumber));
            originDestinationOption.setFlightSegmentSegmentType("A");
            originDestinationOption.setFlightSegmentFlightNumber(Short.valueOf(segment.getFlightNo()));
            LocalDateTime departureDate = LocalDateTime.ofInstant(segment.getStartDate().toInstant(), ZoneId.systemDefault()).withNano(0);
            originDestinationOption.setFlightSegmentDepartureDate(dateTimeFormatter.format(departureDate));
            LocalDateTime arrivalDate = LocalDateTime.ofInstant(segment.getEndDate().toInstant(), ZoneId.systemDefault()).withNano(0);
            originDestinationOption.setFlightSegmentArrivalDate(dateTimeFormatter.format(arrivalDate));
            LocalDateTime bookingDate = LocalDateTime.ofInstant(res.getResDate().toInstant(), pccTimeZone).withNano(0);
            originDestinationOption.setFlightSegmentBookingDate(dateTimeFormatter.format(bookingDate));
            originDestinationOption.setFlightSegmentRealReservationStatus(segment.getStatus());
            originDestinationOption.setFlightSegmentResBookDesigCode(segment.getClassOfSvcCode());
            originDestinationOption.setFlightSegmentDepartureAirport(SabreHelper.getNativeCode((DictionaryReference)segment.getDepartureLocation()));
            originDestinationOption.setFlightSegmentArrivalAirport(SabreHelper.getNativeCode((DictionaryReference)segment.getArriveLocation()));
            StructureFareRulesRQ.OriginDestinationOption.MarketingAirline marketingAirline = new StructureFareRulesRQ.OriginDestinationOption.MarketingAirline();
            marketingAirline.setCode(SabreHelper.getNativeCode((DictionaryReference)segment.getAirline()));
            originDestinationOption.setMarketingAirline(marketingAirline);
            this.collectPaxTypeInformation(originDestinationOption, priceQuoteByPassengerType, segmentNumber);
            destinationOptions.add(originDestinationOption);
        }
        return destinationOptions;
    }

    private void collectPaxTypeInformation(StructureFareRulesRQ.OriginDestinationOption originDestinationOption, Map<String, List<PriceQuoteDetails>> priceQuoteByPassengerType, String segmentNumber) {
        for (Map.Entry<String, List<PriceQuoteDetails>> entry : priceQuoteByPassengerType.entrySet()) {
            StructureFareRulesRQ.OriginDestinationOption.PaxTypeInformation paxTypeInformation = new StructureFareRulesRQ.OriginDestinationOption.PaxTypeInformation();
            paxTypeInformation.setPassengerType(entry.getKey());
            PriceQuoteDetailsFareComponent fareComponent = entry.getValue().stream().flatMap(detail -> detail.getFareInfo().getFareComponentList().stream()).filter(fc -> fc.getFlightSegmentNumbers().getSegmentNumberList().stream().anyMatch(num -> num.toString().equals(segmentNumber))).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"no fare component found for segment number {0}", (Object[])new Object[]{segmentNumber}));
            paxTypeInformation.setFareBasisCode(fareComponent.getFareBasisCode());
            paxTypeInformation.setFareComponentNumber(Short.valueOf(fareComponent.getNumber().shortValue()));
            originDestinationOption.getPaxTypeInformationList().add(paxTypeInformation);
        }
    }

    private StructureFareRulesRQ.PriceRequestInformation getPriceRequestInformation(Map<String, Integer> countByPassengerTypeMap, Product product, ZoneId pccTimeZone) {
        StructureFareRulesRQ.PriceRequestInformation priceRequestInformation = new StructureFareRulesRQ.PriceRequestInformation();
        List passengerTypes = countByPassengerTypeMap.keySet().stream().map(passengerCode -> {
            StructureFareRulesRQ.PriceRequestInformation.PassengerType passengerType = new StructureFareRulesRQ.PriceRequestInformation.PassengerType();
            passengerType.setCode(passengerCode);
            passengerType.setCount(Short.valueOf(((Integer)countByPassengerTypeMap.get(passengerCode)).shortValue()));
            return passengerType;
        }).collect(Collectors.toList());
        priceRequestInformation.setPassengerTypeList(passengerTypes);
        priceRequestInformation.setValidatingCarrier(this.getValidatingCarrier((DictionaryReference<Airline>)product.getCarrier()));
        LocalDateTime buyingDate = LocalDateTime.ofInstant(product.getIssueDate().toInstant(), pccTimeZone).withNano(0);
        priceRequestInformation.setBuyingDate(dateTimeFormatter.format(buyingDate));
        return priceRequestInformation;
    }

    private StructureFareRulesRQ.PriceRequestInformation.ValidatingCarrier getValidatingCarrier(DictionaryReference<Airline> carrier) {
        StructureFareRulesRQ.PriceRequestInformation.ValidatingCarrier validatingCarrier = new StructureFareRulesRQ.PriceRequestInformation.ValidatingCarrier();
        validatingCarrier.setCode(SabreHelper.getNativeCode(carrier));
        return validatingCarrier;
    }

    private void checkOnMarriageSegments(List<Segment> segments, List<StructureFareRulesRQ.OriginDestinationOption> originDestinationOptions) {
        for (int i = 0; i < segments.size(); ++i) {
            if (i == 0) {
                if (i == segments.size() - 1 || !"I".equals(segments.get(i + 1).getMarriageGrp())) continue;
                this.setMarriage(originDestinationOptions.get(i), "S");
                continue;
            }
            if (i == segments.size() - 1) {
                if (!"I".equals(segments.get(i).getMarriageGrp())) continue;
                this.setMarriage(originDestinationOptions.get(i), "E");
                continue;
            }
            if ("O".equals(segments.get(i).getMarriageGrp())) {
                if (!"I".equals(segments.get(i + 1).getMarriageGrp())) continue;
                this.setMarriage(originDestinationOptions.get(i), "S");
                continue;
            }
            if ("I".equals(segments.get(i + 1).getMarriageGrp())) {
                this.setMarriage(originDestinationOptions.get(i), "P");
                continue;
            }
            this.setMarriage(originDestinationOptions.get(i), "E");
        }
    }

    private void setMarriage(StructureFareRulesRQ.OriginDestinationOption originDestinationOption, String status) {
        StructureFareRulesRQ.OriginDestinationOption.Marriage marriage = new StructureFareRulesRQ.OriginDestinationOption.Marriage();
        marriage.setStatus(status);
        originDestinationOption.setMarriage(marriage);
    }
}

