/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.bspCommission;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.sabre.bspCommission.BspCommissionHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class BspCommissionProductsProvider
extends BaseTargetsProvider<List<Product>> {
    public Collection<List<Product>> getTargets(MessageContext ctx) throws Exception {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ArrayList<Product> result = new ArrayList<Product>();
        for (Product product : AirProductHelper.getProducts((Reservation)reservation)) {
            HashSet<String> warnings = new HashSet<String>();
            if (product.getBspCommissionValue() != null) {
                warnings.add("BSP_COMMISSION_BSP_COMMISSION_VALUE_ALREADY_SET");
            }
            if (product.getBspCommissionRate() != null) {
                warnings.add("BSP_COMMISSION_BSP_COMMISSION_RATE_ALREADY_SET");
            }
            if (StringUtils.isBlank((String)product.getCarrierNumber())) {
                warnings.add("BSP_COMMISSION_CARRIER_NUMBER_MISSING");
            }
            if (StringUtils.isBlank((String)product.getSystemNumber())) {
                warnings.add("BSP_COMMISSION_SYSTEM_NUMBER_MISSING");
            }
            if (warnings.isEmpty()) {
                result.add(product);
                continue;
            }
            warnings.forEach(warning -> SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"bsp-commission", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)warning, (Object[])new Object[]{BspCommissionHelper.getProductNumberOrUid(product)})}));
        }
        return result.stream().collect(Collectors.groupingBy(Product::getPcc)).values();
    }
}

