/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.bspCommission;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.bspCommission.BspCommissionHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WTDBAResponseParser
extends BaseProcessor {
    private static final Pattern P_COMM_PCT = Pattern.compile("COMM PCT:(?<value>[0-9]+(\\.[0-9]+)?)");
    private static final Pattern P_COMM_AMT = Pattern.compile("COMM AMT:(?<value>[0-9]+(\\.[0-9]+)?)");

    public void process(MessageContext ctx) throws Exception {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
        Matcher mCommPct = P_COMM_PCT.matcher(response);
        Matcher mCommAmt = P_COMM_AMT.matcher(response);
        String gdsCurrency = product.getGdsCurrency();
        if (mCommPct.find()) {
            BigDecimal commAmt;
            int compare;
            BigDecimal commPct;
            BigDecimal bspCommissionRate = commPct = new BigDecimal(mCommPct.group("value"));
            BigDecimal equivalentFare = AirProductHelper.getEquivalentFare((Product)product);
            BigDecimal bspCommissionValue = WTDBAResponseParser.calculateBspCommissionValue(equivalentFare, gdsCurrency, bspCommissionRate);
            if (mCommAmt.find() && (compare = bspCommissionValue.compareTo(commAmt = new BigDecimal(mCommAmt.group("value")))) != 0) {
                try {
                    if (compare > 0) {
                        BigDecimal adjust = BigDecimal.valueOf((int)Math.pow(10.0, bspCommissionValue.precision() - bspCommissionValue.scale() - (commAmt.precision() - commAmt.scale())));
                        bspCommissionRate = bspCommissionRate.divide(adjust, 2, RoundingMode.UNNECESSARY);
                        bspCommissionValue = WTDBAResponseParser.calculateBspCommissionValue(equivalentFare, gdsCurrency, bspCommissionRate);
                    } else {
                        BigDecimal adjust = BigDecimal.valueOf((int)Math.pow(10.0, commAmt.precision() - commAmt.scale() - (bspCommissionValue.precision() - bspCommissionValue.scale())));
                        bspCommissionRate = bspCommissionRate.multiply(adjust);
                        bspCommissionValue = WTDBAResponseParser.calculateBspCommissionValue(equivalentFare, gdsCurrency, bspCommissionRate);
                    }
                }
                catch (ArithmeticException ex) {
                    SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"bsp-commission", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"BSP_COMMISSION_CORRECTION_FAILED", (Throwable)ex, (Object[])new Object[]{BspCommissionHelper.getProductNumberOrUid(product), commPct, commAmt})});
                }
            }
            product.setBspCommissionRate(Double.valueOf(bspCommissionRate.doubleValue()));
            product.setBspCommissionValue(MoneyHelper.buildMoney((BigDecimal)bspCommissionValue, (String)gdsCurrency));
        } else {
            if (!mCommAmt.find()) {
                throw Xeption.forDeveloper((String)("COMM AMT not found in response:\n" + response), (Object[])new Object[0]);
            }
            product.setBspCommissionValue(MoneyHelper.buildMoney((BigDecimal)new BigDecimal(mCommAmt.group("value")), (String)gdsCurrency));
        }
    }

    private static BigDecimal calculateBspCommissionValue(BigDecimal equivalentFare, String gdsCurrency, BigDecimal bspCommissionRate) {
        if (equivalentFare == null) {
            return BigDecimal.ZERO;
        }
        int scale = WTDBAResponseParser.getDecimalPlaces(gdsCurrency, 2);
        return equivalentFare.multiply(bspCommissionRate).divide(BigDecimal.valueOf(100L), scale, RoundingMode.HALF_UP);
    }

    private static Integer getDecimalPlaces(String currencyCode, Integer defaultValue) {
        if ("RUB".equals(currencyCode)) {
            return 2;
        }
        CurrencyInfo curInfo = (CurrencyInfo)DictionaryCache.get().resolveReference((DictionaryReference)new CurrencyInfoReference(currencyCode));
        if (curInfo != null && curInfo.getIataDecimalPlaces() != null) {
            return curInfo.getIataDecimalPlaces();
        }
        return defaultValue;
    }
}

