/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.bspCommission;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.bspCommission.WTDBAResponseParser;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class WTDBAResponseParserTest
extends TestBase {
    private final WTDBAResponseParser parser = new WTDBAResponseParser();

    private MessageContext prepareContext(String responseFileName, String equivalentFare, String gdsCurrency) throws Exception {
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, (Object)EntityContainer.create((BaseEntity)new BookingFile()));
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE, (Object)IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(responseFileName), (Charset)StandardCharsets.UTF_8));
        Product product = new Product();
        ProductFare pf = new ProductFare();
        pf.setEquivalentFare(new BigDecimal(equivalentFare));
        product.getFares().add(pf);
        product.setGdsCurrency(gdsCurrency);
        ctx.putObject((Enum)IBusGdsContextKeys.PRODUCT, (Object)product);
        return ctx;
    }

    private static void check(MessageContext ctx, String bspCommissionRate, String bspCommissionValue) {
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
        Assert.assertEquals(Optional.ofNullable(bspCommissionRate).map(BigDecimal::new).orElse(null), Optional.ofNullable(product.getBspCommissionRate()).map(r -> BigDecimal.valueOf(r).setScale(2, RoundingMode.UNNECESSARY)).orElse(null));
        Assert.assertEquals(Optional.ofNullable(bspCommissionValue).map(BigDecimal::new).orElse(null), Optional.ofNullable(product.getBspCommissionValue()).map(Money::getValue).orElse(null));
    }

    @Test
    public void testRateCorrection() throws Exception {
        MessageContext ctx = this.prepareContext("WTDBAResponseParserTest-rateCorrection.txt", "198000", "RUB");
        this.parser.process(ctx);
        WTDBAResponseParserTest.check(ctx, "0.10", "198.00");
    }

    @Test
    public void testCase1() throws Exception {
        MessageContext ctx = this.prepareContext("WTDBAResponseParserTest-case1.txt", "45240", "RUB");
        this.parser.process(ctx);
        WTDBAResponseParserTest.check(ctx, "11.00", "4976.40");
    }

    @Test
    public void testCase2() throws Exception {
        MessageContext ctx = this.prepareContext("WTDBAResponseParserTest-case2.txt", "45535", "RUB");
        this.parser.process(ctx);
        WTDBAResponseParserTest.check(ctx, "7.00", "3187.45");
    }

    @Test
    public void testCase3() throws Exception {
        MessageContext ctx = this.prepareContext("WTDBAResponseParserTest-case3.txt", "39000", "RUB");
        this.parser.process(ctx);
        WTDBAResponseParserTest.check(ctx, "0.50", "195.00");
    }

    @Test
    public void testCase4() throws Exception {
        MessageContext ctx = this.prepareContext("WTDBAResponseParserTest-case4.txt", "52965", "RUB");
        this.parser.process(ctx);
        WTDBAResponseParserTest.check(ctx, "7.00", "3707.55");
    }

    @Test
    public void testCase5() throws Exception {
        MessageContext ctx = this.prepareContext("WTDBAResponseParserTest-case5.txt", "40200", "RUB");
        this.parser.process(ctx);
        WTDBAResponseParserTest.check(ctx, "0.10", "40.20");
    }

    @Test
    public void testCase6() throws Exception {
        MessageContext ctx = this.prepareContext("WTDBAResponseParserTest-case6.txt", "7440", "RUB");
        this.parser.process(ctx);
        WTDBAResponseParserTest.check(ctx, "14.00", "1041.60");
    }
}

