/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.cancelAncillaries;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AncillaryServicesUpdatePNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.LocatorWithPartitionType;
import com.sabre.webservices.pnrbuilder.v119.OperationTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.ReceivedFromPNRB;
import com.sabre.webservices.pnrbuilder.v119.RequestEnumerationType;
import com.sabre.webservices.pnrbuilder.v119.RequestType;
import com.sabre.webservices.pnrbuilder.v119.ReservationUpdateItemType;
import com.sabre.webservices.pnrbuilder.v119.ReservationUpdateListType;
import com.sabre.webservices.pnrbuilder.v119.ReturnOptions;
import com.sabre.webservices.pnrbuilder.v119.UpdateReservationRQ;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class LuggageCancelRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection products = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        List<Product> cancelLuggageProducts = products.stream().filter(product -> product.getMcoCategory() == MCOCategory.EXCESS_LUGGAGE).collect(Collectors.toList());
        if (cancelLuggageProducts.isEmpty()) {
            throw Xeption.forDeveloper((String)"Product with MCOCategory EXCESS_LUGGAGE not found", (Object[])new Object[0]);
        }
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        UpdateReservationRQ request = this.buildRequest(response.getReservation().getBookingDetails().getRecordLocator(), ((SabreGdsAccount)accountCtr.getEntity()).getTransactionExecutor(), cancelLuggageProducts);
        request.setVersion("1.19.11");
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"UpdateReservationRQ");
    }

    private UpdateReservationRQ buildRequest(String locatorId, String agentName, Collection<Product> products) {
        UpdateReservationRQ request = this.createRequest(locatorId, agentName);
        for (Product product : products) {
            ReservationUpdateItemType reservationUpdateItem = new ReservationUpdateItemType();
            AncillaryServicesUpdatePNRB ancillaryServicesUpdate = new AncillaryServicesUpdatePNRB();
            reservationUpdateItem.clearChoiceSelect();
            reservationUpdateItem.setAncillaryServicesUpdate(ancillaryServicesUpdate);
            ancillaryServicesUpdate.setOp(OperationTypePNRB.D);
            ancillaryServicesUpdate.setId(product.getGdsId());
            request.getReservationUpdateList().getChoice().getReservationUpdateItemList().add(reservationUpdateItem);
        }
        return request;
    }

    private UpdateReservationRQ createRequest(String locatorId, String agentName) {
        UpdateReservationRQ request = new UpdateReservationRQ();
        ReturnOptions returnOptions = new ReturnOptions();
        returnOptions.setIncludeUpdateDetails(Boolean.valueOf(true));
        returnOptions.setRetrievePNR(Boolean.valueOf(true));
        request.setReturnOptions(returnOptions);
        RequestType requestType = new RequestType();
        requestType.setCommitTransaction(Boolean.valueOf(true));
        requestType.setInitialIgnore(Boolean.valueOf(true));
        requestType.setRequestEnumerationType(RequestEnumerationType.STATELESS);
        request.setRequestType(requestType);
        ReservationUpdateListType reservationUpdateListType = new ReservationUpdateListType();
        LocatorWithPartitionType locator = new LocatorWithPartitionType();
        locator.setString(locatorId);
        reservationUpdateListType.setLocator(locator);
        ReceivedFromPNRB receivedFrom = new ReceivedFromPNRB();
        receivedFrom.setAgentName(agentName);
        reservationUpdateListType.setReceivedFrom(receivedFrom);
        ReservationUpdateListType.Choice choice = new ReservationUpdateListType.Choice();
        reservationUpdateListType.setChoice(choice);
        request.setReservationUpdateList(reservationUpdateListType);
        return request;
    }
}

